/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.api.action;

import com.atlassian.performance.tools.jiraactions.api.ActionTypes;
import com.atlassian.performance.tools.jiraactions.api.WebJira;
import com.atlassian.performance.tools.jiraactions.api.action.Action;
import com.atlassian.performance.tools.jiraactions.api.measure.ActionMeter;
import com.atlassian.performance.tools.jiraactions.api.memories.IssueKeyMemory;
import com.atlassian.performance.tools.jiraactions.api.observation.IssueObservation;
import com.atlassian.performance.tools.jiraactions.api.page.HistoryTabPanel;
import com.atlassian.performance.tools.jiraactions.api.page.IssuePage;
import javax.json.JsonObject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/action/ViewHistoryTabAction;", "Lcom/atlassian/performance/tools/jiraactions/api/action/Action;", "jira", "Lcom/atlassian/performance/tools/jiraactions/api/WebJira;", "meter", "Lcom/atlassian/performance/tools/jiraactions/api/measure/ActionMeter;", "issueKeyMemory", "Lcom/atlassian/performance/tools/jiraactions/api/memories/IssueKeyMemory;", "(Lcom/atlassian/performance/tools/jiraactions/api/WebJira;Lcom/atlassian/performance/tools/jiraactions/api/measure/ActionMeter;Lcom/atlassian/performance/tools/jiraactions/api/memories/IssueKeyMemory;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "run", "", "jira-actions"})
public final class ViewHistoryTabAction
implements Action {
    private final Logger logger;
    private final WebJira jira;
    private final ActionMeter meter;
    private final IssueKeyMemory issueKeyMemory;

    @Override
    public void run() {
        String issueKey = (String)this.issueKeyMemory.recall();
        if (issueKey == null) {
            this.logger.debug("Skipping View History Tab action. I have no knowledge of issue keys.");
            return;
        }
        IssuePage page = this.jira.goToIssue(issueKey).waitForSummary();
        this.meter.measure(ActionTypes.VIEW_HISTORY_TAB, (Function0)new Function0<HistoryTabPanel>(page){
            final /* synthetic */ IssuePage $page;

            @NotNull
            public final HistoryTabPanel invoke() {
                return this.$page.openHistoryTabPanel().showAllHistoryEntries();
            }
            {
                this.$page = issuePage2;
                super(0);
            }
        }, (Function1)new Function1<HistoryTabPanel, JsonObject>(issueKey){
            final /* synthetic */ String $issueKey;

            @NotNull
            public final JsonObject invoke(@NotNull HistoryTabPanel it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return new IssueObservation(this.$issueKey).serialize();
            }
            {
                this.$issueKey = string;
                super(1);
            }
        });
    }

    public ViewHistoryTabAction(@NotNull WebJira jira, @NotNull ActionMeter meter, @NotNull IssueKeyMemory issueKeyMemory) {
        Intrinsics.checkParameterIsNotNull((Object)jira, (String)"jira");
        Intrinsics.checkParameterIsNotNull((Object)meter, (String)"meter");
        Intrinsics.checkParameterIsNotNull((Object)issueKeyMemory, (String)"issueKeyMemory");
        this.jira = jira;
        this.meter = meter;
        this.issueKeyMemory = issueKeyMemory;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }
}

