/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.api;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u000b\u001a\u0004\u0018\u0001H\f\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e\u00a2\u0006\u0002\u0010\u000fJ*\u0010\u0010\u001a\n\u0012\u0004\u0012\u0002H\f\u0018\u00010\u000e\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J!\u0010\u0013\u001a\u0004\u0018\u0001H\f\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/SeededRandom;", "", "seed", "", "(J)V", "logger", "Lorg/apache/logging/log4j/Logger;", "random", "Ljava/util/Random;", "getRandom", "()Ljava/util/Random;", "pick", "T", "list", "", "(Ljava/util/List;)Ljava/lang/Object;", "pickMany", "howMany", "", "randomOrNull", "jira-actions"})
public final class SeededRandom {
    private final Logger logger;
    @NotNull
    private final Random random;

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    @Nullable
    public final <T> T pick(@NotNull List<? extends T> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        return list.isEmpty() ? null : (T)list.get(this.random.nextInt(list.size()));
    }

    @Nullable
    public final <T> List<T> pickMany(@NotNull List<? extends T> list, int howMany) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        return list.size() < howMany ? null : CollectionsKt.shuffled((Iterable)list, (Random)this.random).subList(0, howMany);
    }

    @Nullable
    public final <T> T randomOrNull(@NotNull List<? extends T> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        Collection collection = list;
        return !collection.isEmpty() ? (T)this.pick(list) : null;
    }

    public SeededRandom(long seed) {
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
        this.random = new Random(new Random(seed).nextLong());
        this.logger.debug("Using seed " + seed);
    }

    public /* synthetic */ SeededRandom(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = new Random().nextLong();
        }
        this(l);
    }

    public SeededRandom() {
        this(0L, 1, null);
    }
}

