/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.api;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003J\u0013\u0010\u0018\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\bH\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/BackendTimeSlot;", "", "start", "Ljava/time/Instant;", "end", "threadId", "", "nodeId", "", "(Ljava/time/Instant;Ljava/time/Instant;JLjava/lang/String;)V", "duration", "Ljava/time/Duration;", "getDuration", "()Ljava/time/Duration;", "getEnd", "()Ljava/time/Instant;", "getNodeId", "()Ljava/lang/String;", "getStart", "getThreadId", "()J", "contains", "", "instant", "equals", "other", "hashCode", "", "toString", "jira-actions"})
public final class BackendTimeSlot {
    @NotNull
    private final Duration duration;
    @NotNull
    private final Instant start;
    @NotNull
    private final Instant end;
    private final long threadId;
    @Nullable
    private final String nodeId;

    @NotNull
    public final Duration getDuration() {
        return this.duration;
    }

    public final boolean contains(@NotNull Instant instant) {
        Intrinsics.checkParameterIsNotNull((Object)instant, (String)"instant");
        return instant.isAfter(this.start) && instant.isBefore(this.end);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.atlassian.performance.tools.jiraactions.api.BackendTimeSlot");
        }
        BackendTimeSlot cfr_ignored_0 = (BackendTimeSlot)object2;
        if (Intrinsics.areEqual((Object)this.start, (Object)((BackendTimeSlot)other).start) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.end, (Object)((BackendTimeSlot)other).end) ^ true) {
            return false;
        }
        if (this.threadId != ((BackendTimeSlot)other).threadId) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.nodeId, (Object)((BackendTimeSlot)other).nodeId) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.duration, (Object)((BackendTimeSlot)other).duration) ^ true);
    }

    public int hashCode() {
        int result = this.start.hashCode();
        result = 31 * result + this.end.hashCode();
        result = 31 * result + Long.hashCode(this.threadId);
        String string = this.nodeId;
        result = 31 * result + (string != null ? string.hashCode() : 0);
        result = 31 * result + this.duration.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "BackendTimeSlot(start=" + this.start + ", end=" + this.end + ", threadId=" + this.threadId + ", nodeId=" + this.nodeId + ", duration=" + this.duration + ')';
    }

    @NotNull
    public final Instant getStart() {
        return this.start;
    }

    @NotNull
    public final Instant getEnd() {
        return this.end;
    }

    public final long getThreadId() {
        return this.threadId;
    }

    @Nullable
    public final String getNodeId() {
        return this.nodeId;
    }

    public BackendTimeSlot(@NotNull Instant start, @NotNull Instant end, long threadId, @Nullable String nodeId) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        this.start = start;
        this.end = end;
        this.threadId = threadId;
        this.nodeId = nodeId;
        Duration duration = Duration.between(this.start, this.end);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.between(start, end)");
        this.duration = duration;
    }
}

