/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.loadbalancer;

import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthResult;
import com.amazonaws.services.elasticloadbalancing.model.InstanceState;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerDescription;
import com.atlassian.performance.tools.infrastructure.api.loadbalancer.LoadBalancer;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/loadbalancer/ElasticLoadBalancer;", "Lcom/atlassian/performance/tools/infrastructure/api/loadbalancer/LoadBalancer;", "loadBalancer", "Lcom/amazonaws/services/elasticloadbalancing/AmazonElasticLoadBalancing;", "loadBalancerDescription", "Lcom/amazonaws/services/elasticloadbalancing/model/LoadBalancerDescription;", "(Lcom/amazonaws/services/elasticloadbalancing/AmazonElasticLoadBalancing;Lcom/amazonaws/services/elasticloadbalancing/model/LoadBalancerDescription;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "uri", "Ljava/net/URI;", "getUri", "()Ljava/net/URI;", "isHealthy", "", "waitUntilHealthy", "", "timeout", "Ljava/time/Duration;", "aws-infrastructure"})
public final class ElasticLoadBalancer
implements LoadBalancer {
    @NotNull
    private final URI uri;
    private final Logger logger;
    private final AmazonElasticLoadBalancing loadBalancer;
    private final LoadBalancerDescription loadBalancerDescription;

    @NotNull
    public URI getUri() {
        return this.uri;
    }

    public void waitUntilHealthy(@NotNull Duration timeout) {
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        this.logger.info("Starting load balancer...");
        Instant start = Instant.now();
        while (!this.isHealthy()) {
            if (Instant.now().compareTo(start.plus(timeout)) > 0) {
                throw (Throwable)new RuntimeException("Load balancer didn't start in time");
            }
            Thread.sleep(Duration.ofSeconds(5L).toMillis());
        }
        this.logger.info("Load balancer is started");
    }

    private final boolean isHealthy() {
        boolean bl;
        block3: {
            List instanceStates;
            DescribeInstanceHealthResult describeInstanceHealthResult = this.loadBalancer.describeInstanceHealth(new DescribeInstanceHealthRequest().withLoadBalancerName(this.loadBalancerDescription.getLoadBalancerName()));
            Intrinsics.checkExpressionValueIsNotNull((Object)describeInstanceHealthResult, (String)"loadBalancer\n           \u2026lancerName)\n            )");
            List list = instanceStates = describeInstanceHealthResult.getInstanceStates();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"instanceStates");
            Iterable $receiver$iv = list;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    InstanceState it = (InstanceState)element$iv;
                    boolean bl2 = false;
                    InstanceState instanceState = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)instanceState, (String)"it");
                    if (!(Intrinsics.areEqual((Object)instanceState.getState(), (Object)"InService") ^ true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return !bl;
    }

    public ElasticLoadBalancer(@NotNull AmazonElasticLoadBalancing loadBalancer, @NotNull LoadBalancerDescription loadBalancerDescription) {
        Intrinsics.checkParameterIsNotNull((Object)loadBalancer, (String)"loadBalancer");
        Intrinsics.checkParameterIsNotNull((Object)loadBalancerDescription, (String)"loadBalancerDescription");
        this.loadBalancer = loadBalancer;
        this.loadBalancerDescription = loadBalancerDescription;
        this.uri = new URI("http://" + this.loadBalancerDescription.getDNSName() + '/');
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }
}

