/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.jira.home;

import com.atlassian.performance.tools.aws.api.Storage;
import com.atlassian.performance.tools.aws.api.StorageLocation;
import com.atlassian.performance.tools.awsinfrastructure.api.aws.AwsCli;
import com.atlassian.performance.tools.awsinfrastructure.api.hardware.Computer;
import com.atlassian.performance.tools.infrastructure.api.jira.JiraHomeSource;
import com.atlassian.performance.tools.infrastructure.api.jira.SharedHome;
import com.atlassian.performance.tools.infrastructure.api.os.Ubuntu;
import com.atlassian.performance.tools.ssh.api.Ssh;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/jira/home/SharedHomeFormula;", "", "pluginsTransport", "Lcom/atlassian/performance/tools/aws/api/Storage;", "jiraHomeSource", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;", "ip", "", "ssh", "Lcom/atlassian/performance/tools/ssh/api/Ssh;", "computer", "Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Computer;", "(Lcom/atlassian/performance/tools/aws/api/Storage;Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;Ljava/lang/String;Lcom/atlassian/performance/tools/ssh/api/Ssh;Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Computer;)V", "localSharedHome", "localSubnet", "ubuntu", "Lcom/atlassian/performance/tools/infrastructure/api/os/Ubuntu;", "provision", "Lcom/atlassian/performance/tools/infrastructure/api/jira/SharedHome;", "aws-infrastructure"})
public final class SharedHomeFormula {
    private final String localSubnet = "10.0.0.0/24";
    private final String localSharedHome = "/home/ubuntu/jira-shared-home";
    private final Ubuntu ubuntu;
    private final Storage pluginsTransport;
    private final JiraHomeSource jiraHomeSource;
    private final String ip;
    private final Ssh ssh;
    private final Computer computer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SharedHome provision() {
        Closeable closeable = (Closeable)this.ssh.newConnection();
        Throwable throwable = null;
        try {
            SshConnection it = (SshConnection)closeable;
            boolean bl = false;
            this.computer.setUp$aws_infrastructure(it);
            String jiraHome = this.jiraHomeSource.download(it);
            AwsCli awsCli = new AwsCli();
            StorageLocation storageLocation = this.pluginsTransport.getLocation();
            String string = jiraHome + "/plugins/installed-plugins";
            Duration duration = Duration.ofMinutes(3L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(3)");
            awsCli.download(storageLocation, it, string, duration);
            it.execute("sudo mkdir -p " + this.localSharedHome);
            it.safeExecute("sudo mv " + jiraHome + "/{data,plugins,import,export} " + this.localSharedHome);
            it.safeExecute("sudo mv " + jiraHome + "/logos " + this.localSharedHome);
            Ubuntu.install$default((Ubuntu)this.ubuntu, (SshConnection)it, (List)CollectionsKt.listOf((Object)"nfs-kernel-server"), null, (int)4, null);
            it.execute("sudo echo '" + this.localSharedHome + ' ' + this.localSubnet + "(rw,sync,no_subtree_check,no_root_squash)' | sudo tee -a /etc/exports");
            SshConnection.SshResult sshResult = it.execute("sudo service nfs-kernel-server restart");
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return new SharedHome(this.ip, this.localSharedHome);
    }

    public SharedHomeFormula(@NotNull Storage pluginsTransport, @NotNull JiraHomeSource jiraHomeSource, @NotNull String ip, @NotNull Ssh ssh, @NotNull Computer computer) {
        Intrinsics.checkParameterIsNotNull((Object)pluginsTransport, (String)"pluginsTransport");
        Intrinsics.checkParameterIsNotNull((Object)jiraHomeSource, (String)"jiraHomeSource");
        Intrinsics.checkParameterIsNotNull((Object)ip, (String)"ip");
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)computer, (String)"computer");
        this.pluginsTransport = pluginsTransport;
        this.jiraHomeSource = jiraHomeSource;
        this.ip = ip;
        this.ssh = ssh;
        this.computer = computer;
        this.localSubnet = "10.0.0.0/24";
        this.localSharedHome = "/home/ubuntu/jira-shared-home";
        this.ubuntu = new Ubuntu();
    }
}

