/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.jira;

import com.atlassian.performance.tools.aws.api.Storage;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.StartedNode;
import com.atlassian.performance.tools.awsinfrastructure.jira.JiraStatus;
import com.atlassian.performance.tools.awsinfrastructure.jira.StoppedNode;
import com.atlassian.performance.tools.infrastructure.api.jira.JiraLaunchTimeouts;
import com.atlassian.performance.tools.infrastructure.api.jvm.JavaDevelopmentKit;
import com.atlassian.performance.tools.infrastructure.api.jvm.ThreadDump;
import com.atlassian.performance.tools.infrastructure.api.os.OsMetric;
import com.atlassian.performance.tools.infrastructure.api.process.RemoteMonitoringProcess;
import com.atlassian.performance.tools.infrastructure.api.profiler.Profiler;
import com.atlassian.performance.tools.ssh.api.Ssh;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.io.Closeable;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001Bs\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020!H\u0002J6\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020!2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00032\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0*H\u0002JF\u0010+\u001a\u00020,2<\u0010-\u001a8\u00124\u00122\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b/\u0012\b\b\u0002\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b/\u0012\b\b\u0002\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020#0.0\nH\u0016J\u0010\u00100\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020!H\u0002J\b\u00101\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0002J0\u00102\u001a\u00020#2\u0006\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u0002052\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010\u000e\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0017\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/jira/StandaloneStoppedNode;", "Lcom/atlassian/performance/tools/awsinfrastructure/jira/StoppedNode;", "name", "", "jiraHome", "analyticLogs", "resultsTransport", "Lcom/atlassian/performance/tools/aws/api/Storage;", "unpackedProduct", "osMetrics", "", "Lcom/atlassian/performance/tools/infrastructure/api/os/OsMetric;", "waitForRunning", "", "waitForUpgrades", "launchTimeouts", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraLaunchTimeouts;", "jdk", "Lcom/atlassian/performance/tools/infrastructure/api/jvm/JavaDevelopmentKit;", "profiler", "Lcom/atlassian/performance/tools/infrastructure/api/profiler/Profiler;", "ssh", "Lcom/atlassian/performance/tools/ssh/api/Ssh;", "adminPasswordPlainText", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/atlassian/performance/tools/aws/api/Storage;Ljava/lang/String;Ljava/util/List;ZZLcom/atlassian/performance/tools/infrastructure/api/jira/JiraLaunchTimeouts;Lcom/atlassian/performance/tools/infrastructure/api/jvm/JavaDevelopmentKit;Lcom/atlassian/performance/tools/infrastructure/api/profiler/Profiler;Lcom/atlassian/performance/tools/ssh/api/Ssh;Ljava/lang/String;)V", "getJiraHome", "()Ljava/lang/String;", "logger", "Lorg/apache/logging/log4j/Logger;", "getSsh", "()Lcom/atlassian/performance/tools/ssh/api/Ssh;", "pid", "", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "pollJira", "", "timeout", "Ljava/time/Duration;", "threadDump", "Lcom/atlassian/performance/tools/infrastructure/api/jvm/ThreadDump;", "checkName", "check", "Lkotlin/Function0;", "start", "Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/StartedNode;", "updateConfigurationFunction", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "startJira", "toString", "waitForStatusToChange", "statusQuo", "uri", "Ljava/net/URI;", "aws-infrastructure"})
public final class StandaloneStoppedNode
implements StoppedNode {
    private final Logger logger;
    private final String name;
    @NotNull
    private final String jiraHome;
    private final String analyticLogs;
    private final Storage resultsTransport;
    private final String unpackedProduct;
    private final List<OsMetric> osMetrics;
    private final boolean waitForRunning;
    private final boolean waitForUpgrades;
    private final JiraLaunchTimeouts launchTimeouts;
    private final JavaDevelopmentKit jdk;
    private final Profiler profiler;
    @NotNull
    private final Ssh ssh;
    private final String adminPasswordPlainText;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public StartedNode start(@NotNull List<? extends Function2<? super Ssh, ? super String, Unit>> updateConfigurationFunction) {
        Intrinsics.checkParameterIsNotNull(updateConfigurationFunction, (String)"updateConfigurationFunction");
        this.logger.info("Starting '" + this.name + "'...");
        List monitoringProcesses = new ArrayList();
        Closeable closeable = (Closeable)this.getSsh().newConnection();
        Throwable throwable = null;
        try {
            SshConnection sshConnection = (SshConnection)closeable;
            boolean bl = false;
            Iterable $receiver$iv = this.osMetrics;
            for (Object element$iv : $receiver$iv) {
                OsMetric metric = (OsMetric)element$iv;
                boolean bl2 = false;
                monitoringProcesses.add(metric.start(sshConnection));
            }
            $receiver$iv = updateConfigurationFunction;
            RemoteMonitoringProcess remoteMonitoringProcess = $receiver$iv.iterator();
            while (remoteMonitoringProcess.hasNext()) {
                Object element$iv;
                element$iv = remoteMonitoringProcess.next();
                Function2 it = (Function2)element$iv;
                boolean bl3 = false;
                it.invoke((Object)this.getSsh(), (Object)this.unpackedProduct);
            }
            this.startJira(sshConnection);
            int pid = this.pid(sshConnection);
            monitoringProcesses.add(this.jdk.getJstatMonitoring().start(sshConnection, pid));
            RemoteMonitoringProcess remoteMonitoringProcess2 = this.profiler.start(sshConnection, pid);
            if (remoteMonitoringProcess2 != null) {
                RemoteMonitoringProcess it = remoteMonitoringProcess = remoteMonitoringProcess2;
                boolean bl4 = false;
                monitoringProcesses.add(it);
            }
            ThreadDump threadDump = new ThreadDump(pid, this.jdk);
            try {
                this.waitForRunning(sshConnection, threadDump);
                this.waitForUpgrades(sshConnection, threadDump);
            }
            catch (Exception exception) {
                new StartedNode(this.name, this.getJiraHome(), this.analyticLogs, this.resultsTransport, this.unpackedProduct, monitoringProcesses, this.getSsh()).gatherResults();
                throw (Throwable)new Exception("Failed to start the Jira node.", exception);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.logger.info('\'' + this.name + "' is started");
        return new StartedNode(this.name, this.getJiraHome(), this.analyticLogs, this.resultsTransport, this.unpackedProduct, monitoringProcesses, this.getSsh());
    }

    private final void startJira(SshConnection ssh) {
        String string = StringsKt.trimMargin$default((String)("\n            |" + this.jdk.use() + "\n            |./" + this.unpackedProduct + "/bin/start-jira.sh\n            "), null, (int)1, null);
        Duration duration = Duration.ofMinutes(1L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"ofMinutes(1)");
        ssh.execute(string, duration);
    }

    private final int pid(SshConnection ssh) {
        String string;
        String string2 = string = ssh.execute("cat " + this.unpackedProduct + "/work/catalina.pid").getOutput();
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        return Integer.parseInt(string);
    }

    private final void waitForRunning(SshConnection ssh, ThreadDump threadDump) {
        if (!this.waitForRunning) {
            this.logger.debug("Skipping Jira startup wait");
            return;
        }
        URI statusEndpoint = new URI("http://admin:" + this.adminPasswordPlainText + "@localhost:8080/status");
        this.pollJira(this.launchTimeouts.getInitTimeout(), ssh, threadDump, "RUNNING state", (Function0<Boolean>)((Function0)new Function0<Boolean>(this, ssh, statusEndpoint){
            final /* synthetic */ StandaloneStoppedNode this$0;
            final /* synthetic */ SshConnection $ssh;
            final /* synthetic */ URI $statusEndpoint;

            public final boolean invoke() {
                String string = "curl --silent " + this.$statusEndpoint;
                Duration duration = StandaloneStoppedNode.access$getLaunchTimeouts$p(this.this$0).getUnresponsivenessTimeout();
                Level level = Level.DEBUG;
                Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.DEBUG");
                Level level2 = Level.DEBUG;
                Intrinsics.checkExpressionValueIsNotNull((Object)level2, (String)"Level.DEBUG");
                SshConnection.SshResult curl = this.$ssh.safeExecute(string, duration, level, level2);
                return curl.isSuccessful() && JiraStatus.Parser.INSTANCE.parseResponse(curl.getOutput()) == JiraStatus.RUNNING;
            }
            {
                this.this$0 = standaloneStoppedNode;
                this.$ssh = sshConnection;
                this.$statusEndpoint = uRI;
                super(0);
            }
        }));
    }

    private final void waitForUpgrades(SshConnection ssh, ThreadDump threadDump) {
        if (!this.waitForUpgrades) {
            this.logger.debug("Skipping Jira upgrade wait");
            return;
        }
        this.logger.debug("Waiting for Jira node to upgrade...");
        URI upgradesEndpoint = new URI("http://admin:" + this.adminPasswordPlainText + "@localhost:8080/rest/api/2/upgrade");
        ThreadDump threadDump2 = threadDump;
        URI uRI = upgradesEndpoint;
        SshConnection sshConnection = ssh;
        Duration duration = this.launchTimeouts.getOfflineTimeout();
        this.waitForStatusToChange("000", uRI, duration, sshConnection, threadDump2);
        threadDump2 = threadDump;
        uRI = upgradesEndpoint;
        sshConnection = ssh;
        duration = this.launchTimeouts.getInitTimeout();
        this.waitForStatusToChange("503", uRI, duration, sshConnection, threadDump2);
        String string = "curl --silent --retry 6 -X POST " + upgradesEndpoint;
        Duration duration2 = Duration.ofSeconds(15L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"ofSeconds(15)");
        ssh.execute(string, duration2);
        threadDump2 = threadDump;
        uRI = upgradesEndpoint;
        sshConnection = ssh;
        duration = this.launchTimeouts.getUpgradeTimeout();
        this.waitForStatusToChange("303", uRI, duration, sshConnection, threadDump2);
    }

    private final void waitForStatusToChange(String statusQuo, URI uri, Duration timeout, SshConnection ssh, ThreadDump threadDump) {
        this.pollJira(timeout, ssh, threadDump, "upgrades passing " + statusQuo + " status", (Function0<Boolean>)((Function0)new Function0<Boolean>(this, ssh, uri, statusQuo){
            final /* synthetic */ StandaloneStoppedNode this$0;
            final /* synthetic */ SshConnection $ssh;
            final /* synthetic */ URI $uri;
            final /* synthetic */ String $statusQuo;

            public final boolean invoke() {
                String newStatus = this.$ssh.safeExecute("curl --silent --write-out '%{http_code}' --output /dev/null -X GET " + this.$uri, StandaloneStoppedNode.access$getLaunchTimeouts$p(this.this$0).getUnresponsivenessTimeout()).getOutput();
                return Intrinsics.areEqual((Object)newStatus, (Object)this.$statusQuo) ^ true;
            }
            {
                this.this$0 = standaloneStoppedNode;
                this.$ssh = sshConnection;
                this.$uri = uRI;
                this.$statusQuo = string;
                super(0);
            }
        }));
    }

    private final void pollJira(Duration timeout, SshConnection ssh, ThreadDump threadDump, String checkName, Function0<Boolean> check) {
        Duration backoff = Duration.ofSeconds(10L);
        Instant deadline = Instant.now().plus(timeout);
        while (!((Boolean)check.invoke()).booleanValue()) {
            if (deadline.compareTo(Instant.now()) < 0) {
                if (this.logger.isDebugEnabled()) {
                    String string = "cat " + this.getJiraHome() + "/log/atlassian-jira.log";
                    Duration duration = Duration.ofMinutes(3L);
                    Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"ofMinutes(3)");
                    String logContent = ssh.safeExecute(string, duration).getOutput();
                    this.logger.debug("Jira log file: <<" + logContent + ">>");
                }
                throw (Throwable)new Exception("Jira didn't pass " + checkName + " check in " + timeout);
            }
            threadDump.gather(ssh, "thread-dumps");
            Thread.sleep(backoff.toMillis());
        }
    }

    @NotNull
    public String toString() {
        return "StandaloneStoppedNode(name='" + this.name + "', jiraHome='" + this.getJiraHome() + "', analyticLogs='" + this.analyticLogs + "', resultsTransport=" + this.resultsTransport + ", unpackedProduct='" + this.unpackedProduct + "', osMetrics=" + this.osMetrics + ", waitForRunning=" + this.waitForRunning + ", waitForUpgrades=" + this.waitForUpgrades + ", launchTimeouts=" + this.launchTimeouts + ", jdk=" + this.jdk + ", profiler=" + this.profiler + ')';
    }

    @Override
    @NotNull
    public String getJiraHome() {
        return this.jiraHome;
    }

    @Override
    @NotNull
    public Ssh getSsh() {
        return this.ssh;
    }

    public StandaloneStoppedNode(@NotNull String name, @NotNull String jiraHome, @NotNull String analyticLogs, @NotNull Storage resultsTransport, @NotNull String unpackedProduct, @NotNull List<? extends OsMetric> osMetrics, boolean waitForRunning2, boolean waitForUpgrades, @NotNull JiraLaunchTimeouts launchTimeouts, @NotNull JavaDevelopmentKit jdk, @NotNull Profiler profiler, @NotNull Ssh ssh, @NotNull String adminPasswordPlainText) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)jiraHome, (String)"jiraHome");
        Intrinsics.checkParameterIsNotNull((Object)analyticLogs, (String)"analyticLogs");
        Intrinsics.checkParameterIsNotNull((Object)resultsTransport, (String)"resultsTransport");
        Intrinsics.checkParameterIsNotNull((Object)unpackedProduct, (String)"unpackedProduct");
        Intrinsics.checkParameterIsNotNull(osMetrics, (String)"osMetrics");
        Intrinsics.checkParameterIsNotNull((Object)launchTimeouts, (String)"launchTimeouts");
        Intrinsics.checkParameterIsNotNull((Object)jdk, (String)"jdk");
        Intrinsics.checkParameterIsNotNull((Object)profiler, (String)"profiler");
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)adminPasswordPlainText, (String)"adminPasswordPlainText");
        this.name = name;
        this.jiraHome = jiraHome;
        this.analyticLogs = analyticLogs;
        this.resultsTransport = resultsTransport;
        this.unpackedProduct = unpackedProduct;
        this.osMetrics = osMetrics;
        this.waitForRunning = waitForRunning2;
        this.waitForUpgrades = waitForUpgrades;
        this.launchTimeouts = launchTimeouts;
        this.jdk = jdk;
        this.profiler = profiler;
        this.ssh = ssh;
        this.adminPasswordPlainText = adminPasswordPlainText;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }

    public static final /* synthetic */ JiraLaunchTimeouts access$getLaunchTimeouts$p(StandaloneStoppedNode $this) {
        return $this.launchTimeouts;
    }
}

