/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api.jira;

import com.atlassian.performance.tools.ssh.api.Ssh;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import com.atlassian.performance.tools.ssh.api.SshHost;
import java.io.Closeable;
import java.time.Duration;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/StoppableNode;", "", "jiraPath", "", "ssh", "Lcom/atlassian/performance/tools/ssh/api/Ssh;", "(Ljava/lang/String;Lcom/atlassian/performance/tools/ssh/api/Ssh;)V", "stop", "", "toJson", "Ljavax/json/JsonObject;", "Builder", "aws-infrastructure"})
public final class StoppableNode {
    private final String jiraPath;
    private final Ssh ssh;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Closeable closeable = (Closeable)this.ssh.newConnection();
        Throwable throwable = null;
        try {
            SshConnection ssh = (SshConnection)closeable;
            boolean bl = false;
            String string = "source ~/.profile; " + this.jiraPath + "/bin/stop-jira.sh";
            Duration duration = Duration.ofMinutes(3L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(3)");
            SshConnection.SshResult sshResult = ssh.execute(string, duration);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final JsonObject toJson() {
        JsonObject jsonObject = Json.createObjectBuilder().add("jiraPath", this.jiraPath).add("ssh", (JsonValue)this.ssh.getHost().toJson()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"Json.createObjectBuilder\u2026n())\n            .build()");
        return jsonObject;
    }

    private StoppableNode(String jiraPath, Ssh ssh) {
        this.jiraPath = jiraPath;
        this.ssh = ssh;
    }

    public /* synthetic */ StoppableNode(String jiraPath, Ssh ssh, DefaultConstructorMarker $constructor_marker) {
        this(jiraPath, ssh);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/StoppableNode$Builder;", "", "json", "Ljavax/json/JsonObject;", "(Ljavax/json/JsonObject;)V", "jiraPath", "", "ssh", "Lcom/atlassian/performance/tools/ssh/api/Ssh;", "(Ljava/lang/String;Lcom/atlassian/performance/tools/ssh/api/Ssh;)V", "build", "Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/StoppableNode;", "aws-infrastructure"})
    public static final class Builder {
        private String jiraPath;
        private Ssh ssh;

        @NotNull
        public final Builder jiraPath(@NotNull String jiraPath) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)jiraPath, (String)"jiraPath");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.jiraPath = jiraPath;
            return builder;
        }

        @NotNull
        public final Builder ssh(@NotNull Ssh ssh) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.ssh = ssh;
            return builder;
        }

        @NotNull
        public final StoppableNode build() {
            return new StoppableNode(this.jiraPath, this.ssh, null);
        }

        public Builder(@NotNull String jiraPath, @NotNull Ssh ssh) {
            Intrinsics.checkParameterIsNotNull((Object)jiraPath, (String)"jiraPath");
            Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
            this.jiraPath = jiraPath;
            this.ssh = ssh;
        }

        public Builder(@NotNull JsonObject json) {
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            String string = json.getString("jiraPath");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"json.getString(\"jiraPath\")");
            JsonObject jsonObject = json.getJsonObject("ssh");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"json.getJsonObject(\"ssh\")");
            this(string, new Ssh(new SshHost(jsonObject)));
        }
    }
}

