/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api.jira;

import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.atlassian.performance.tools.aws.api.Aws;
import com.atlassian.performance.tools.aws.api.DependentResources;
import com.atlassian.performance.tools.aws.api.Investment;
import com.atlassian.performance.tools.aws.api.ProvisionedStack;
import com.atlassian.performance.tools.aws.api.Resource;
import com.atlassian.performance.tools.aws.api.SshKey;
import com.atlassian.performance.tools.aws.api.SshKeyFile;
import com.atlassian.performance.tools.aws.api.StackFormula;
import com.atlassian.performance.tools.aws.api.Storage;
import com.atlassian.performance.tools.awsinfrastructure.InstanceFilters;
import com.atlassian.performance.tools.awsinfrastructure.TemplateBuilder;
import com.atlassian.performance.tools.awsinfrastructure.api.RemoteLocation;
import com.atlassian.performance.tools.awsinfrastructure.api.hardware.C4EightExtraLargeElastic;
import com.atlassian.performance.tools.awsinfrastructure.api.hardware.Computer;
import com.atlassian.performance.tools.awsinfrastructure.api.hardware.M4ExtraLargeElastic;
import com.atlassian.performance.tools.awsinfrastructure.api.hardware.Volume;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.Jira;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.JiraFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.ProvisionedJira;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.StandaloneFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.StartedNode;
import com.atlassian.performance.tools.awsinfrastructure.api.network.Network;
import com.atlassian.performance.tools.awsinfrastructure.api.network.NetworkFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.network.ProvisionedNetwork;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.AccessProvider;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.AccessRequester;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.ForIpAccessRequester;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.LocalPublicIpv4Provider;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.MultiAccessProvider;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.SecurityGroupIngressAccessProvider;
import com.atlassian.performance.tools.awsinfrastructure.jira.StandaloneNodeFormula;
import com.atlassian.performance.tools.awsinfrastructure.jira.StandaloneStoppedNode;
import com.atlassian.performance.tools.concurrency.api.AbruptExecutorService;
import com.atlassian.performance.tools.concurrency.api.TaskContextKt;
import com.atlassian.performance.tools.infrastructure.api.app.Apps;
import com.atlassian.performance.tools.infrastructure.api.database.Database;
import com.atlassian.performance.tools.infrastructure.api.distribution.ProductDistribution;
import com.atlassian.performance.tools.infrastructure.api.jira.JiraHomeSource;
import com.atlassian.performance.tools.infrastructure.api.jira.JiraNodeConfig;
import com.atlassian.performance.tools.infrastructure.api.jvm.jmx.RemoteJmx;
import com.atlassian.performance.tools.jvmtasks.api.TaskScope;
import com.atlassian.performance.tools.ssh.api.Ssh;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import com.atlassian.performance.tools.ssh.api.SshHost;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00011B\u0083\u0001\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\u0006\u0010\u0014\u001a\u00020\r\u0012\u0006\u0010\u0015\u001a\u00020\u000f\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001dJ>\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020.H\u0016JF\u0010\"\u001a\u00020#2\u0006\u0010/\u001a\u0002002\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020.H\u0002R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/StandaloneFormula;", "Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/JiraFormula;", "apps", "Lcom/atlassian/performance/tools/infrastructure/api/app/Apps;", "productDistribution", "Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;", "jiraHomeSource", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;", "database", "Lcom/atlassian/performance/tools/infrastructure/api/database/Database;", "config", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraNodeConfig;", "computer", "Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Computer;", "jiraVolume", "Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Volume;", "stackCreationTimeout", "Ljava/time/Duration;", "overriddenNetwork", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/Network;", "databaseComputer", "databaseVolume", "accessRequester", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/access/AccessRequester;", "adminPasswordPlainText", "", "waitForRunning", "", "waitForUpgrades", "(Lcom/atlassian/performance/tools/infrastructure/api/app/Apps;Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;Lcom/atlassian/performance/tools/infrastructure/api/database/Database;Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraNodeConfig;Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Computer;Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Volume;Ljava/time/Duration;Lcom/atlassian/performance/tools/awsinfrastructure/api/network/Network;Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Computer;Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Volume;Lcom/atlassian/performance/tools/awsinfrastructure/api/network/access/AccessRequester;Ljava/lang/String;ZZ)V", "logger", "Lorg/apache/logging/log4j/Logger;", "getProductDistribution$aws_infrastructure", "()Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;", "provision", "Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/ProvisionedJira;", "investment", "Lcom/atlassian/performance/tools/aws/api/Investment;", "pluginsTransport", "Lcom/atlassian/performance/tools/aws/api/Storage;", "resultsTransport", "key", "Ljava/util/concurrent/Future;", "Lcom/atlassian/performance/tools/aws/api/SshKey;", "roleProfile", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "executor", "Ljava/util/concurrent/ExecutorService;", "Builder", "aws-infrastructure"})
public final class StandaloneFormula
implements JiraFormula {
    private final Logger logger;
    private final Apps apps;
    @NotNull
    private final ProductDistribution productDistribution;
    private final JiraHomeSource jiraHomeSource;
    private final Database database;
    private final JiraNodeConfig config;
    private final Computer computer;
    private final Volume jiraVolume;
    private final Duration stackCreationTimeout;
    private final Network overriddenNetwork;
    private final Computer databaseComputer;
    private final Volume databaseVolume;
    private final AccessRequester accessRequester;
    private final String adminPasswordPlainText;
    private final boolean waitForRunning;
    private final boolean waitForUpgrades;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ProvisionedJira provision(@NotNull Investment investment, @NotNull Storage pluginsTransport, @NotNull Storage resultsTransport, @NotNull Future<SshKey> key, @NotNull String roleProfile, @NotNull Aws aws) {
        ProvisionedJira provisionedJira;
        Intrinsics.checkParameterIsNotNull((Object)investment, (String)"investment");
        Intrinsics.checkParameterIsNotNull((Object)pluginsTransport, (String)"pluginsTransport");
        Intrinsics.checkParameterIsNotNull((Object)resultsTransport, (String)"resultsTransport");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)roleProfile, (String)"roleProfile");
        Intrinsics.checkParameterIsNotNull((Object)aws, (String)"aws");
        this.logger.info("Setting up Jira...");
        ExecutorService executorService = Executors.newFixedThreadPool(4, new ThreadFactoryBuilder().setNameFormat("standalone-provisioning-thread-%d").build());
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newFixedThread\u2026   .build()\n            )");
        AutoCloseable autoCloseable = (AutoCloseable)new AbruptExecutorService(executorService);
        Throwable throwable = null;
        try {
            AbruptExecutorService executor = (AbruptExecutorService)autoCloseable;
            boolean bl = false;
            provisionedJira = this.provision((ExecutorService)executor, investment, pluginsTransport, resultsTransport, key, roleProfile, aws);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return provisionedJira;
    }

    /*
     * WARNING - void declaration
     */
    private final ProvisionedJira provision(ExecutorService executor, Investment investment, Storage pluginsTransport, Storage resultsTransport, Future<SshKey> key, String roleProfile, Aws aws) {
        void $receiver$iv$iv;
        void $receiver$iv;
        MultiAccessProvider multiAccessProvider;
        Iterable $receiver$iv$iv2;
        void $receiver$iv2;
        MultiAccessProvider multiAccessProvider2;
        SecurityGroupIngressAccessProvider securityGroupIngressAccessProvider;
        Collection<SecurityGroupIngressAccessProvider> collection;
        Iterable $receiver$iv$iv3;
        void $receiver$iv3;
        MultiAccessProvider multiAccessProvider3;
        String databaseSshIp;
        String jiraSshIp;
        ProvisionedNetwork provisionedNetwork2 = new NetworkFormula(investment, aws).reuseOrProvision$aws_infrastructure(this.overriddenNetwork);
        Network network = provisionedNetwork2.getNetwork();
        String template = new TemplateBuilder("single-node.yaml").adaptTo(CollectionsKt.listOf((Object)this.config));
        CompletableFuture stackProvisioning2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"provision stack", (Function0)((Function0)new Function0<ProvisionedStack>(this, investment, template, key, roleProfile, aws, network){
            final /* synthetic */ StandaloneFormula this$0;
            final /* synthetic */ Investment $investment;
            final /* synthetic */ String $template;
            final /* synthetic */ Future $key;
            final /* synthetic */ String $roleProfile;
            final /* synthetic */ Aws $aws;
            final /* synthetic */ Network $network;

            @NotNull
            public final ProvisionedStack invoke() {
                Duration duration = StandaloneFormula.access$getStackCreationTimeout$p(this.this$0);
                Duration duration2 = null;
                Aws aws = this.$aws;
                List list = CollectionsKt.listOf((Object[])new Parameter[]{new Parameter().withParameterKey("KeyName").withParameterValue(((SshKey)this.$key.get()).getRemote().getName()), new Parameter().withParameterKey("InstanceProfile").withParameterValue(this.$roleProfile), new Parameter().withParameterKey("Ami").withParameterValue(this.$aws.getDefaultAmi()), new Parameter().withParameterKey("JiraInstanceType").withParameterValue(StandaloneFormula.access$getComputer$p(this.this$0).getInstanceType$aws_infrastructure().toString()), new Parameter().withParameterKey("JiraVolumeSize").withParameterValue(String.valueOf(StandaloneFormula.access$getJiraVolume$p(this.this$0).getSize())), new Parameter().withParameterKey("DatabaseInstanceType").withParameterValue(StandaloneFormula.access$getDatabaseComputer$p(this.this$0).getInstanceType$aws_infrastructure().toString()), new Parameter().withParameterKey("DatabaseVolumeSize").withParameterValue(String.valueOf(StandaloneFormula.access$getDatabaseVolume$p(this.this$0).getSize())), new Parameter().withParameterKey("Vpc").withParameterValue(this.$network.getVpc().getVpcId()), new Parameter().withParameterKey("Subnet").withParameterValue(this.$network.getSubnet().getSubnetId())});
                String string = this.$template;
                return new StackFormula(this.$investment, aws, string, list, duration2, duration, 16, null).provision();
            }
            {
                this.this$0 = standaloneFormula;
                this.$investment = investment;
                this.$template = string;
                this.$key = future;
                this.$roleProfile = string2;
                this.$aws = aws;
                this.$network = network;
                super(0);
            }
        }));
        CompletableFuture uploadPlugins2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"upload plugins", (Function0)((Function0)new Function0<Unit>(this, pluginsTransport){
            final /* synthetic */ StandaloneFormula this$0;
            final /* synthetic */ Storage $pluginsTransport;

            public final void invoke() {
                Iterable $receiver$iv = StandaloneFormula.access$getApps$p(this.this$0).listFiles();
                for (T element$iv : $receiver$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    this.$pluginsTransport.upload(it);
                }
            }
            {
                this.this$0 = standaloneFormula;
                this.$pluginsTransport = storage;
                super(0);
            }
        }));
        ProvisionedStack jiraStack = (ProvisionedStack)stackProvisioning2.get();
        Path keyPath = key.get().getFile().getPath();
        List machines = jiraStack.listMachines();
        Instance jiraMachine = (Instance)CollectionsKt.single(new InstanceFilters().jiraInstances$aws_infrastructure(machines));
        String jiraPublicIp = jiraMachine.getPublicIpAddress();
        URI jiraPublicHttpAddress = new URI("http://" + jiraPublicIp + ":8080/");
        String string = jiraSshIp = jiraMachine.getPublicIpAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jiraSshIp");
        Ssh jiraSsh = new Ssh(new SshHost(string, "ubuntu", keyPath), 5);
        Instance databaseMachine = new InstanceFilters().dbInstance$aws_infrastructure(machines);
        String databasePrivateIp = databaseMachine.getPrivateIpAddress();
        String string2 = databaseSshIp = databaseMachine.getPublicIpAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"databaseSshIp");
        Ssh databaseSsh = new Ssh(new SshHost(string2, "ubuntu", keyPath), 4);
        key.get().getFile().facilitateSsh(jiraSshIp);
        String string3 = databasePrivateIp;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"databasePrivateIp");
        boolean bl = this.waitForUpgrades;
        boolean bl2 = this.waitForRunning;
        String string4 = this.adminPasswordPlainText;
        Object object = this.computer;
        Ssh ssh = jiraSsh;
        ProductDistribution productDistribution = this.productDistribution;
        String string5 = string3;
        Storage storage = resultsTransport;
        Storage storage2 = pluginsTransport;
        JiraHomeSource jiraHomeSource = this.jiraHomeSource;
        JiraNodeConfig jiraNodeConfig = this.config;
        StandaloneNodeFormula nodeFormula = new StandaloneNodeFormula(jiraHomeSource, storage2, storage, string5, productDistribution, ssh, bl2, bl, jiraNodeConfig, (Computer)object, string4);
        SecurityGroup jiraNodeSecurityGroup = jiraStack.findSecurityGroup("JiraNodeSecurityGroup");
        int n = 8080;
        SecurityGroupIngressAccessProvider jiraNodeHttpAccessProvider = new SecurityGroupIngressAccessProvider.Builder(aws.getEc2(), jiraNodeSecurityGroup, new IntRange(n, 8080)).build();
        object = CollectionsKt.toSet((Iterable)this.config.getDebug().getRequiredPorts());
        MultiAccessProvider multiAccessProvider4 = multiAccessProvider3;
        MultiAccessProvider multiAccessProvider5 = multiAccessProvider3;
        ssh = $receiver$iv3;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv3) {
            void it;
            int n2 = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl3 = false;
            void var36_43 = it;
            securityGroupIngressAccessProvider = new SecurityGroupIngressAccessProvider.Builder(aws.getEc2(), jiraNodeSecurityGroup, new IntRange((int)var36_43, (int)it)).build();
            collection.add(securityGroupIngressAccessProvider);
        }
        collection = (List)destination$iv$iv;
        multiAccessProvider4((List<? extends AccessProvider>)collection);
        MultiAccessProvider jiraNodeJvmDebugAccessProvider = multiAccessProvider5;
        $receiver$iv$iv3 = CollectionsKt.toSet((Iterable)this.config.getRemoteJmx().getRequiredPorts());
        multiAccessProvider4 = multiAccessProvider2;
        multiAccessProvider5 = multiAccessProvider2;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it;
            int bl3 = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv2;
            boolean bl4 = false;
            void $i$f$mapTo = it;
            securityGroupIngressAccessProvider = new SecurityGroupIngressAccessProvider.Builder(aws.getEc2(), jiraNodeSecurityGroup, new IntRange((int)$i$f$mapTo, (int)it)).build();
            collection.add(securityGroupIngressAccessProvider);
        }
        collection = (List)destination$iv$iv2;
        multiAccessProvider4((List<? extends AccessProvider>)collection);
        MultiAccessProvider jiraNodeJmxAccessProvider = multiAccessProvider5;
        $receiver$iv$iv2 = CollectionsKt.toSet((Iterable)this.config.getSplunkForwarder().getRequiredPorts());
        multiAccessProvider4 = multiAccessProvider;
        multiAccessProvider5 = multiAccessProvider;
        destination$iv$iv2 = $receiver$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            int bl4 = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv3;
            boolean bl5 = false;
            void $i$f$mapTo = it;
            securityGroupIngressAccessProvider = new SecurityGroupIngressAccessProvider.Builder(aws.getEc2(), jiraNodeSecurityGroup, new IntRange((int)$i$f$mapTo, (int)it)).build();
            collection.add(securityGroupIngressAccessProvider);
        }
        collection = (List)destination$iv$iv3;
        multiAccessProvider4((List<? extends AccessProvider>)collection);
        MultiAccessProvider jiraNodeSplunkForwarderAccessProvider = multiAccessProvider5;
        MultiAccessProvider jiraAccessProvider = new MultiAccessProvider(CollectionsKt.listOf((Object[])new AccessProvider[]{jiraNodeHttpAccessProvider, jiraNodeJvmDebugAccessProvider, jiraNodeJmxAccessProvider, jiraNodeSplunkForwarderAccessProvider}));
        CompletableFuture selfDashboardAccess2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"self dashboard access", (Function0)((Function0)new Function0<Boolean>(jiraPublicIp, jiraNodeHttpAccessProvider){
            final /* synthetic */ String $jiraPublicIp;
            final /* synthetic */ SecurityGroupIngressAccessProvider $jiraNodeHttpAccessProvider;

            public final boolean invoke() {
                return new ForIpAccessRequester(new Supplier<String>(this){
                    final /* synthetic */ provision.selfDashboardAccess.1 this$0;

                    public final String get() {
                        return this.this$0.$jiraPublicIp;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }).requestAccess(this.$jiraNodeHttpAccessProvider);
            }
            {
                this.$jiraPublicIp = string;
                this.$jiraNodeHttpAccessProvider = securityGroupIngressAccessProvider;
                super(0);
            }
        }));
        CompletableFuture externalAccess2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"external access", (Function0)((Function0)new Function0<Boolean>(this, jiraAccessProvider){
            final /* synthetic */ StandaloneFormula this$0;
            final /* synthetic */ MultiAccessProvider $jiraAccessProvider;

            public final boolean invoke() {
                return StandaloneFormula.access$getAccessRequester$p(this.this$0).requestAccess(this.$jiraAccessProvider);
            }
            {
                this.this$0 = standaloneFormula;
                this.$jiraAccessProvider = multiAccessProvider;
                super(0);
            }
        }));
        CompletableFuture setupDatabase2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"database", (Function0)((Function0)new Function0<RemoteLocation>(this, databaseSsh, key, databaseSshIp, jiraPublicHttpAddress){
            final /* synthetic */ StandaloneFormula this$0;
            final /* synthetic */ Ssh $databaseSsh;
            final /* synthetic */ Future $key;
            final /* synthetic */ String $databaseSshIp;
            final /* synthetic */ URI $jiraPublicHttpAddress;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final RemoteLocation invoke() {
                RemoteLocation remoteLocation;
                Closeable closeable = (Closeable)this.$databaseSsh.newConnection();
                Throwable throwable = null;
                try {
                    SshConnection it = (SshConnection)closeable;
                    boolean bl = false;
                    StandaloneFormula.access$getDatabaseComputer$p(this.this$0).setUp$aws_infrastructure(it);
                    StandaloneFormula.access$getLogger$p(this.this$0).info("Setting up database...");
                    SshKeyFile sshKeyFile = ((SshKey)this.$key.get()).getFile();
                    String string = this.$databaseSshIp;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"databaseSshIp");
                    sshKeyFile.facilitateSsh(string);
                    String databaseDataLocation = StandaloneFormula.access$getDatabase$p(this.this$0).setup(it);
                    StandaloneFormula.access$getLogger$p(this.this$0).info("Database is set up");
                    StandaloneFormula.access$getLogger$p(this.this$0).info("Starting database...");
                    StandaloneFormula.access$getDatabase$p(this.this$0).start(this.$jiraPublicHttpAddress, it);
                    StandaloneFormula.access$getLogger$p(this.this$0).info("Database is started");
                    remoteLocation = new RemoteLocation(this.$databaseSsh.getHost(), databaseDataLocation);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return remoteLocation;
            }
            {
                this.this$0 = standaloneFormula;
                this.$databaseSsh = ssh;
                this.$key = future;
                this.$databaseSshIp = string;
                this.$jiraPublicHttpAddress = uRI;
                super(0);
            }
        }));
        uploadPlugins2.get();
        StandaloneStoppedNode provisionedNode = nodeFormula.provision();
        RemoteLocation databaseDataLocation = (RemoteLocation)setupDatabase2.get();
        StartedNode node2 = (StartedNode)TaskScope.INSTANCE.task("start", (Callable)new Callable<StartedNode>(provisionedNode){
            final /* synthetic */ StandaloneStoppedNode $provisionedNode;

            @NotNull
            public final StartedNode call() {
                return this.$provisionedNode.start(CollectionsKt.emptyList());
            }
            {
                this.$provisionedNode = standaloneStoppedNode;
            }
        });
        if (!((Boolean)selfDashboardAccess2.get()).booleanValue()) {
            this.logger.warn("It's possible that Jira doesn't have HTTP access to itself. Dashboards may not work.");
        }
        if (!((Boolean)externalAccess2.get()).booleanValue()) {
            this.logger.warn("It's possible that defined external access to Jira resources (e.g. http, debug, splunk) wasn't granted.");
        }
        List list = CollectionsKt.listOf((Object)node2);
        RemoteLocation remoteLocation = new RemoteLocation(jiraSsh.getHost(), provisionedNode.getJiraHome());
        RemoteLocation remoteLocation2 = databaseDataLocation;
        Intrinsics.checkExpressionValueIsNotNull((Object)remoteLocation2, (String)"databaseDataLocation");
        Jira.Builder builder = new Jira.Builder(list, remoteLocation, remoteLocation2, jiraPublicHttpAddress);
        RemoteJmx remoteJmx = this.config.getRemoteJmx();
        String string6 = jiraPublicIp;
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"jiraPublicIp");
        Jira jira = builder.jmxClients(CollectionsKt.listOf((Object)remoteJmx.getClient(string6))).build();
        this.logger.info(jira + " is set up, will expire " + jiraStack.getExpiry());
        ProvisionedJira.Builder builder2 = new ProvisionedJira.Builder(jira);
        ProvisionedStack provisionedStack = jiraStack;
        Intrinsics.checkExpressionValueIsNotNull((Object)provisionedStack, (String)"jiraStack");
        return builder2.resource((Resource)new DependentResources((Resource)provisionedStack, provisionedNetwork2.getResource())).accessProvider(jiraAccessProvider).build();
    }

    @NotNull
    public final ProductDistribution getProductDistribution$aws_infrastructure() {
        return this.productDistribution;
    }

    private StandaloneFormula(Apps apps, ProductDistribution productDistribution, JiraHomeSource jiraHomeSource, Database database, JiraNodeConfig config, Computer computer, Volume jiraVolume, Duration stackCreationTimeout, Network overriddenNetwork, Computer databaseComputer, Volume databaseVolume, AccessRequester accessRequester, String adminPasswordPlainText, boolean waitForRunning2, boolean waitForUpgrades) {
        this.apps = apps;
        this.productDistribution = productDistribution;
        this.jiraHomeSource = jiraHomeSource;
        this.database = database;
        this.config = config;
        this.computer = computer;
        this.jiraVolume = jiraVolume;
        this.stackCreationTimeout = stackCreationTimeout;
        this.overriddenNetwork = overriddenNetwork;
        this.databaseComputer = databaseComputer;
        this.databaseVolume = databaseVolume;
        this.accessRequester = accessRequester;
        this.adminPasswordPlainText = adminPasswordPlainText;
        this.waitForRunning = waitForRunning2;
        this.waitForUpgrades = waitForUpgrades;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }

    /* synthetic */ StandaloneFormula(Apps apps, ProductDistribution productDistribution, JiraHomeSource jiraHomeSource, Database database, JiraNodeConfig jiraNodeConfig, Computer computer, Volume volume, Duration duration, Network network, Computer computer2, Volume volume2, AccessRequester accessRequester, String string, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            network = null;
        }
        this(apps, productDistribution, jiraHomeSource, database, jiraNodeConfig, computer, volume, duration, network, computer2, volume2, accessRequester, string, bl, bl2);
    }

    public /* synthetic */ StandaloneFormula(Apps apps, ProductDistribution productDistribution, JiraHomeSource jiraHomeSource, Database database, JiraNodeConfig config, Computer computer, Volume jiraVolume, Duration stackCreationTimeout, Network overriddenNetwork, Computer databaseComputer, Volume databaseVolume, AccessRequester accessRequester, String adminPasswordPlainText, boolean waitForRunning2, boolean waitForUpgrades, DefaultConstructorMarker $constructor_marker) {
        this(apps, productDistribution, jiraHomeSource, database, config, computer, jiraVolume, stackCreationTimeout, overriddenNetwork, databaseComputer, databaseVolume, accessRequester, adminPasswordPlainText, waitForRunning2, waitForUpgrades);
    }

    public static final /* synthetic */ Logger access$getLogger$p(StandaloneFormula $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010!\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0013J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0018J\u0015\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\"J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u001fR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/StandaloneFormula$Builder;", "", "formula", "Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/StandaloneFormula;", "(Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/StandaloneFormula;)V", "productDistribution", "Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;", "jiraHomeSource", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;", "database", "Lcom/atlassian/performance/tools/infrastructure/api/database/Database;", "(Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;Lcom/atlassian/performance/tools/infrastructure/api/database/Database;)V", "accessRequester", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/access/AccessRequester;", "adminPasswordPlainText", "", "apps", "Lcom/atlassian/performance/tools/infrastructure/api/app/Apps;", "computer", "Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Computer;", "config", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraNodeConfig;", "databaseComputer", "databaseVolume", "Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Volume;", "jiraVolume", "network", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/Network;", "stackCreationTimeout", "Ljava/time/Duration;", "waitForRunning", "", "waitForUpgrades", "build", "network$aws_infrastructure", "aws-infrastructure"})
    public static final class Builder {
        private JiraNodeConfig config;
        private Apps apps;
        private Computer computer;
        private Volume jiraVolume;
        private Duration stackCreationTimeout;
        private Network network;
        private Computer databaseComputer;
        private Volume databaseVolume;
        private AccessRequester accessRequester;
        private String adminPasswordPlainText;
        private boolean waitForRunning;
        private boolean waitForUpgrades;
        private final ProductDistribution productDistribution;
        private final JiraHomeSource jiraHomeSource;
        private final Database database;

        @NotNull
        public final Builder config(@NotNull JiraNodeConfig config) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.config = config;
            return builder;
        }

        @NotNull
        public final Builder apps(@NotNull Apps apps) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)apps, (String)"apps");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.apps = apps;
            return builder;
        }

        @NotNull
        public final Builder computer(@NotNull Computer computer) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)computer, (String)"computer");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.computer = computer;
            return builder;
        }

        @NotNull
        public final Builder jiraVolume(@NotNull Volume jiraVolume) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)jiraVolume, (String)"jiraVolume");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.jiraVolume = jiraVolume;
            return builder;
        }

        @NotNull
        public final Builder stackCreationTimeout(@NotNull Duration stackCreationTimeout) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)stackCreationTimeout, (String)"stackCreationTimeout");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.stackCreationTimeout = stackCreationTimeout;
            return builder;
        }

        @NotNull
        public final Builder databaseComputer(@NotNull Computer databaseComputer) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)databaseComputer, (String)"databaseComputer");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.databaseComputer = databaseComputer;
            return builder;
        }

        @NotNull
        public final Builder databaseVolume(@NotNull Volume databaseVolume) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)databaseVolume, (String)"databaseVolume");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.databaseVolume = databaseVolume;
            return builder;
        }

        @NotNull
        public final Builder adminPasswordPlainText(@NotNull String adminPasswordPlainText) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)adminPasswordPlainText, (String)"adminPasswordPlainText");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.adminPasswordPlainText = adminPasswordPlainText;
            return builder;
        }

        @NotNull
        public final Builder network$aws_infrastructure(@NotNull Network network) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.network = network;
            return builder;
        }

        @NotNull
        public final Builder accessRequester(@NotNull AccessRequester accessRequester) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)accessRequester, (String)"accessRequester");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.accessRequester = accessRequester;
            return builder;
        }

        @NotNull
        public final Builder waitForRunning(boolean waitForRunning2) {
            Builder builder;
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.waitForRunning = waitForRunning2;
            return builder;
        }

        @NotNull
        public final Builder waitForUpgrades(boolean waitForUpgrades) {
            Builder builder;
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.waitForUpgrades = waitForUpgrades;
            return builder;
        }

        @NotNull
        public final StandaloneFormula build() {
            return new StandaloneFormula(this.apps, this.productDistribution, this.jiraHomeSource, this.database, this.config, this.computer, this.jiraVolume, this.stackCreationTimeout, this.network, this.databaseComputer, this.databaseVolume, this.accessRequester, this.adminPasswordPlainText, this.waitForRunning, this.waitForUpgrades, null);
        }

        public Builder(@NotNull ProductDistribution productDistribution, @NotNull JiraHomeSource jiraHomeSource, @NotNull Database database) {
            Intrinsics.checkParameterIsNotNull((Object)productDistribution, (String)"productDistribution");
            Intrinsics.checkParameterIsNotNull((Object)jiraHomeSource, (String)"jiraHomeSource");
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            this.productDistribution = productDistribution;
            this.jiraHomeSource = jiraHomeSource;
            this.database = database;
            this.config = new JiraNodeConfig.Builder().build();
            this.apps = new Apps(CollectionsKt.emptyList());
            this.computer = new C4EightExtraLargeElastic();
            this.jiraVolume = new Volume(200);
            Duration duration = Duration.ofMinutes(30L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(30)");
            this.stackCreationTimeout = duration;
            this.databaseComputer = new M4ExtraLargeElastic();
            this.databaseVolume = new Volume(100);
            this.accessRequester = new ForIpAccessRequester(new LocalPublicIpv4Provider.Builder().build());
            this.adminPasswordPlainText = "admin";
            this.waitForUpgrades = true;
        }

        public Builder(@NotNull StandaloneFormula formula) {
            Intrinsics.checkParameterIsNotNull((Object)formula, (String)"formula");
            this(formula.getProductDistribution$aws_infrastructure(), formula.jiraHomeSource, formula.database);
            this.config = formula.config;
            this.apps = formula.apps;
            this.computer = formula.computer;
            this.jiraVolume = formula.jiraVolume;
            this.stackCreationTimeout = formula.stackCreationTimeout;
            this.network = formula.overriddenNetwork;
            this.databaseComputer = formula.databaseComputer;
            this.databaseVolume = formula.databaseVolume;
            this.accessRequester = formula.accessRequester;
            this.adminPasswordPlainText = formula.adminPasswordPlainText;
            this.waitForRunning = formula.waitForRunning;
            this.waitForUpgrades = formula.waitForUpgrades;
        }
    }
}

