/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api.jira;

import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.Subnet;
import com.amazonaws.services.ec2.model.Vpc;
import com.atlassian.performance.tools.aws.api.Aws;
import com.atlassian.performance.tools.aws.api.DependentResources;
import com.atlassian.performance.tools.aws.api.Investment;
import com.atlassian.performance.tools.aws.api.ProvisionedStack;
import com.atlassian.performance.tools.aws.api.Resource;
import com.atlassian.performance.tools.aws.api.SshKey;
import com.atlassian.performance.tools.aws.api.SshKeyFile;
import com.atlassian.performance.tools.aws.api.StackFormula;
import com.atlassian.performance.tools.aws.api.Storage;
import com.atlassian.performance.tools.awsinfrastructure.InstanceFilters;
import com.atlassian.performance.tools.awsinfrastructure.TemplateBuilder;
import com.atlassian.performance.tools.awsinfrastructure.api.RemoteLocation;
import com.atlassian.performance.tools.awsinfrastructure.api.hardware.C4EightExtraLargeElastic;
import com.atlassian.performance.tools.awsinfrastructure.api.hardware.Computer;
import com.atlassian.performance.tools.awsinfrastructure.api.hardware.M4ExtraLargeElastic;
import com.atlassian.performance.tools.awsinfrastructure.api.hardware.Volume;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.Jira;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.JiraFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.ProvisionedJira;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.StartedNode;
import com.atlassian.performance.tools.awsinfrastructure.api.loadbalancer.ApacheEc2LoadBalancerFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.loadbalancer.ApacheProxyLoadBalancer;
import com.atlassian.performance.tools.awsinfrastructure.api.loadbalancer.LoadBalancerFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.loadbalancer.ProvisionedLoadBalancer;
import com.atlassian.performance.tools.awsinfrastructure.api.network.Network;
import com.atlassian.performance.tools.awsinfrastructure.api.network.NetworkFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.network.ProvisionedNetwork;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.AccessProvider;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.AccessRequester;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.ForIpAccessRequester;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.LocalPublicIpv4Provider;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.MultiAccessProvider;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.MultiAccessRequester;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.SecurityGroupIngressAccessProvider;
import com.atlassian.performance.tools.awsinfrastructure.jira.DataCenterNodeFormula;
import com.atlassian.performance.tools.awsinfrastructure.jira.DiagnosableNodeFormula;
import com.atlassian.performance.tools.awsinfrastructure.jira.NodeFormula;
import com.atlassian.performance.tools.awsinfrastructure.jira.StandaloneNodeFormula;
import com.atlassian.performance.tools.awsinfrastructure.jira.StoppedNode;
import com.atlassian.performance.tools.awsinfrastructure.jira.home.SharedHomeFormula;
import com.atlassian.performance.tools.concurrency.api.AbruptExecutorService;
import com.atlassian.performance.tools.concurrency.api.TaskContextKt;
import com.atlassian.performance.tools.infrastructure.api.app.Apps;
import com.atlassian.performance.tools.infrastructure.api.database.Database;
import com.atlassian.performance.tools.infrastructure.api.distribution.ProductDistribution;
import com.atlassian.performance.tools.infrastructure.api.jira.JiraHomeSource;
import com.atlassian.performance.tools.infrastructure.api.jira.JiraNodeConfig;
import com.atlassian.performance.tools.infrastructure.api.jira.SharedHome;
import com.atlassian.performance.tools.infrastructure.api.jvm.jmx.JmxClient;
import com.atlassian.performance.tools.infrastructure.api.jvm.jmx.RemoteJmx;
import com.atlassian.performance.tools.infrastructure.api.loadbalancer.LoadBalancer;
import com.atlassian.performance.tools.jvmtasks.api.EventBus;
import com.atlassian.performance.tools.jvmtasks.api.TaskScope;
import com.atlassian.performance.tools.ssh.api.Ssh;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import com.atlassian.performance.tools.ssh.api.SshHost;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.reflect.KDeclarationContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00012B\u0091\u0001\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0010\u0012\u0006\u0010\u0018\u001a\u00020\u0012\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u0012\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0002\u0010 J>\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/H\u0016JF\u0010#\u001a\u00020$2\u0006\u00100\u001a\u0002012\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/H\u0002R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/DataCenterFormula;", "Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/JiraFormula;", "configs", "", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraNodeConfig;", "loadBalancerFormula", "Lcom/atlassian/performance/tools/awsinfrastructure/api/loadbalancer/LoadBalancerFormula;", "apps", "Lcom/atlassian/performance/tools/infrastructure/api/app/Apps;", "productDistribution", "Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;", "jiraHomeSource", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;", "database", "Lcom/atlassian/performance/tools/infrastructure/api/database/Database;", "computer", "Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Computer;", "jiraVolume", "Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Volume;", "stackCreationTimeout", "Ljava/time/Duration;", "overriddenNetwork", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/Network;", "databaseComputer", "databaseVolume", "accessRequester", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/access/AccessRequester;", "adminPasswordPlainText", "", "waitForRunning", "", "waitForUpgrades", "(Ljava/util/List;Lcom/atlassian/performance/tools/awsinfrastructure/api/loadbalancer/LoadBalancerFormula;Lcom/atlassian/performance/tools/infrastructure/api/app/Apps;Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;Lcom/atlassian/performance/tools/infrastructure/api/database/Database;Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Computer;Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Volume;Ljava/time/Duration;Lcom/atlassian/performance/tools/awsinfrastructure/api/network/Network;Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Computer;Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Volume;Lcom/atlassian/performance/tools/awsinfrastructure/api/network/access/AccessRequester;Ljava/lang/String;ZZ)V", "logger", "Lorg/apache/logging/log4j/Logger;", "provision", "Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/ProvisionedJira;", "investment", "Lcom/atlassian/performance/tools/aws/api/Investment;", "pluginsTransport", "Lcom/atlassian/performance/tools/aws/api/Storage;", "resultsTransport", "key", "Ljava/util/concurrent/Future;", "Lcom/atlassian/performance/tools/aws/api/SshKey;", "roleProfile", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "executor", "Ljava/util/concurrent/ExecutorService;", "Builder", "aws-infrastructure"})
public final class DataCenterFormula
implements JiraFormula {
    private final Logger logger;
    private final List<JiraNodeConfig> configs;
    private final LoadBalancerFormula loadBalancerFormula;
    private final Apps apps;
    private final ProductDistribution productDistribution;
    private final JiraHomeSource jiraHomeSource;
    private final Database database;
    private final Computer computer;
    private final Volume jiraVolume;
    private final Duration stackCreationTimeout;
    private final Network overriddenNetwork;
    private final Computer databaseComputer;
    private final Volume databaseVolume;
    private final AccessRequester accessRequester;
    private final String adminPasswordPlainText;
    private final boolean waitForRunning;
    private final boolean waitForUpgrades;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ProvisionedJira provision(@NotNull Investment investment, @NotNull Storage pluginsTransport, @NotNull Storage resultsTransport, @NotNull Future<SshKey> key, @NotNull String roleProfile, @NotNull Aws aws) {
        ProvisionedJira provisionedJira;
        Intrinsics.checkParameterIsNotNull((Object)investment, (String)"investment");
        Intrinsics.checkParameterIsNotNull((Object)pluginsTransport, (String)"pluginsTransport");
        Intrinsics.checkParameterIsNotNull((Object)resultsTransport, (String)"resultsTransport");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)roleProfile, (String)"roleProfile");
        Intrinsics.checkParameterIsNotNull((Object)aws, (String)"aws");
        this.logger.info("Setting up Jira...");
        ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("data-center-provisioning-thread-%d").build());
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newCachedThrea\u2026   .build()\n            )");
        AutoCloseable autoCloseable = (AutoCloseable)new AbruptExecutorService(executorService);
        Throwable throwable = null;
        try {
            AbruptExecutorService executor = (AbruptExecutorService)autoCloseable;
            boolean bl = false;
            provisionedJira = this.provision((ExecutorService)executor, investment, pluginsTransport, resultsTransport, key, roleProfile, aws);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return provisionedJira;
    }

    /*
     * WARNING - void declaration
     */
    private final ProvisionedJira provision(ExecutorService executor, Investment investment, Storage pluginsTransport, Storage resultsTransport, Future<SshKey> key, String roleProfile, Aws aws) {
        void instances;
        DependentResources $receiver$iv$iv;
        void $receiver$iv;
        StoppedNode it;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv2;
        void $receiver$iv$iv3;
        void $receiver$iv3;
        MultiAccessProvider multiAccessProvider;
        Iterable $receiver$iv$iv4;
        Iterable $receiver$iv4;
        MultiAccessProvider multiAccessProvider2;
        Iterable $receiver$iv$iv5;
        Iterable $receiver$iv5;
        MultiAccessProvider multiAccessProvider3;
        SecurityGroupIngressAccessProvider securityGroupIngressAccessProvider;
        Iterable $receiver$iv$iv6;
        Iterable $receiver$iv6;
        MultiAccessProvider multiAccessProvider4;
        Object object;
        void instance;
        Object object2;
        Object item$iv$iv2;
        void $receiver$iv$iv7;
        Iterable $receiver$iv7;
        ProvisionedNetwork provisionedNetwork2 = new NetworkFormula(investment, aws).reuseOrProvision$aws_infrastructure(this.overriddenNetwork);
        Network network = provisionedNetwork2.getNetwork();
        String template = new TemplateBuilder("2-nodes-dc.yaml").adaptTo(this.configs);
        CompletableFuture stackProvisioning2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"provision stack", (Function0)((Function0)new Function0<ProvisionedStack>(this, investment, template, key, roleProfile, aws, network){
            final /* synthetic */ DataCenterFormula this$0;
            final /* synthetic */ Investment $investment;
            final /* synthetic */ String $template;
            final /* synthetic */ Future $key;
            final /* synthetic */ String $roleProfile;
            final /* synthetic */ Aws $aws;
            final /* synthetic */ Network $network;

            @NotNull
            public final ProvisionedStack invoke() {
                Duration duration = DataCenterFormula.access$getStackCreationTimeout$p(this.this$0);
                Duration duration2 = null;
                Aws aws = this.$aws;
                List list = CollectionsKt.listOf((Object[])new Parameter[]{new Parameter().withParameterKey("KeyName").withParameterValue(((SshKey)this.$key.get()).getRemote().getName()), new Parameter().withParameterKey("InstanceProfile").withParameterValue(this.$roleProfile), new Parameter().withParameterKey("Ami").withParameterValue(this.$aws.getDefaultAmi()), new Parameter().withParameterKey("JiraInstanceType").withParameterValue(DataCenterFormula.access$getComputer$p(this.this$0).getInstanceType$aws_infrastructure().toString()), new Parameter().withParameterKey("JiraVolumeSize").withParameterValue(String.valueOf(DataCenterFormula.access$getJiraVolume$p(this.this$0).getSize())), new Parameter().withParameterKey("DatabaseInstanceType").withParameterValue(DataCenterFormula.access$getDatabaseComputer$p(this.this$0).getInstanceType$aws_infrastructure().toString()), new Parameter().withParameterKey("DatabaseVolumeSize").withParameterValue(String.valueOf(DataCenterFormula.access$getDatabaseVolume$p(this.this$0).getSize())), new Parameter().withParameterKey("Vpc").withParameterValue(this.$network.getVpc().getVpcId()), new Parameter().withParameterKey("Subnet").withParameterValue(this.$network.getSubnet().getSubnetId())});
                String string = this.$template;
                return new StackFormula(this.$investment, aws, string, list, duration2, duration, 16, null).provision();
            }
            {
                this.this$0 = dataCenterFormula;
                this.$investment = investment;
                this.$template = string;
                this.$key = future;
                this.$roleProfile = string2;
                this.$aws = aws;
                this.$network = network;
                super(0);
            }
        }));
        CompletableFuture uploadPlugins2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"upload plugins", (Function0)((Function0)new Function0<Unit>(this, pluginsTransport){
            final /* synthetic */ DataCenterFormula this$0;
            final /* synthetic */ Storage $pluginsTransport;

            public final void invoke() {
                Iterable $receiver$iv = DataCenterFormula.access$getApps$p(this.this$0).listFiles();
                for (T element$iv : $receiver$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    this.$pluginsTransport.upload(it);
                }
            }
            {
                this.this$0 = dataCenterFormula;
                this.$pluginsTransport = storage;
                super(0);
            }
        }));
        ProvisionedStack jiraStack = (ProvisionedStack)stackProvisioning2.get();
        Path keyPath = key.get().getFile().getPath();
        List machines = jiraStack.listMachines();
        List<Instance> jiraNodes = new InstanceFilters().jiraInstances$aws_infrastructure(machines);
        Instance databaseMachine = new InstanceFilters().dbInstance$aws_infrastructure(machines);
        Instance sharedHomeMachine = new InstanceFilters().sharedHome$aws_infrastructure(machines);
        String string = sharedHomeMachine.getPublicIpAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sharedHomeMachine.publicIpAddress");
        SshHost sharedHomeSshHost = new SshHost(string, "ubuntu", keyPath);
        CompletableFuture futureLoadBalancer2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"provision load balancer", (Function0)((Function0)new Function0<ProvisionedLoadBalancer>(this, investment, jiraNodes, network, key, aws){
            final /* synthetic */ DataCenterFormula this$0;
            final /* synthetic */ Investment $investment;
            final /* synthetic */ List $jiraNodes;
            final /* synthetic */ Network $network;
            final /* synthetic */ Future $key;
            final /* synthetic */ Aws $aws;

            @NotNull
            public final ProvisionedLoadBalancer invoke() {
                LoadBalancerFormula loadBalancerFormula = DataCenterFormula.access$getLoadBalancerFormula$p(this.this$0);
                Subnet subnet = this.$network.getSubnet();
                Vpc vpc = this.$network.getVpc();
                V v = this.$key.get();
                Intrinsics.checkExpressionValueIsNotNull(v, (String)"key.get()");
                Aws aws = this.$aws;
                SshKey sshKey = (SshKey)v;
                Vpc vpc2 = vpc;
                Subnet subnet2 = subnet;
                return loadBalancerFormula.provision(this.$investment, this.$jiraNodes, vpc2, subnet2, sshKey, aws);
            }
            {
                this.this$0 = dataCenterFormula;
                this.$investment = investment;
                this.$jiraNodes = list;
                this.$network = network;
                this.$key = future;
                this.$aws = aws;
                super(0);
            }
        }));
        uploadPlugins2.get();
        CompletableFuture sharedHome2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"provision shared home", (Function0)((Function0)new Function0<SharedHome>(this, sharedHomeMachine, sharedHomeSshHost, key, pluginsTransport){
            final /* synthetic */ DataCenterFormula this$0;
            final /* synthetic */ Instance $sharedHomeMachine;
            final /* synthetic */ SshHost $sharedHomeSshHost;
            final /* synthetic */ Future $key;
            final /* synthetic */ Storage $pluginsTransport;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final SharedHome invoke() {
                void var2_7;
                EventBus.INSTANCE.publish((Object)this.$sharedHomeMachine);
                DataCenterFormula.access$getLogger$p(this.this$0).info("Setting up shared home...");
                Ssh sharedHomeSsh = new Ssh(this.$sharedHomeSshHost, 4);
                SshKeyFile sshKeyFile = ((SshKey)this.$key.get()).getFile();
                String string = this.$sharedHomeMachine.getPublicIpAddress();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sharedHomeMachine.publicIpAddress");
                sshKeyFile.facilitateSsh(string);
                JiraHomeSource jiraHomeSource = DataCenterFormula.access$getJiraHomeSource$p(this.this$0);
                String string2 = this.$sharedHomeMachine.getPrivateIpAddress();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sharedHomeMachine.privateIpAddress");
                Computer computer = DataCenterFormula.access$getComputer$p(this.this$0);
                Ssh ssh = sharedHomeSsh;
                String string3 = string2;
                Storage storage = this.$pluginsTransport;
                JiraHomeSource jiraHomeSource2 = jiraHomeSource;
                SharedHome sharedHome2 = new SharedHomeFormula(storage, jiraHomeSource2, string3, ssh, computer).provision();
                DataCenterFormula.access$getLogger$p(this.this$0).info("Shared home is set up");
                return var2_7;
            }
            {
                this.this$0 = dataCenterFormula;
                this.$sharedHomeMachine = instance;
                this.$sharedHomeSshHost = sshHost;
                this.$key = future;
                this.$pluginsTransport = storage;
                super(0);
            }
        }));
        Iterable iterable = $receiver$iv7 = (Iterable)jiraNodes;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv7, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $receiver$iv$iv7) {
            void i;
            int n = index$iv$iv++;
            Instance instance2 = (Instance)item$iv$iv2;
            int n2 = n;
            object2 = destination$iv$iv;
            boolean bl = false;
            JiraNodeConfig nodeConfig = this.configs.get((int)i);
            object = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)("install " + nodeConfig.getName()), (Function0)((Function0)new Function0<StoppedNode>((Instance)instance, nodeConfig, this, executor, keyPath, key, resultsTransport, databaseMachine, pluginsTransport, sharedHome2){
                final /* synthetic */ Instance $instance;
                final /* synthetic */ JiraNodeConfig $nodeConfig;
                final /* synthetic */ DataCenterFormula this$0;
                final /* synthetic */ ExecutorService $executor$inlined;
                final /* synthetic */ Path $keyPath$inlined;
                final /* synthetic */ Future $key$inlined;
                final /* synthetic */ Storage $resultsTransport$inlined;
                final /* synthetic */ Instance $databaseMachine$inlined;
                final /* synthetic */ Storage $pluginsTransport$inlined;
                final /* synthetic */ CompletableFuture $sharedHome$inlined;
                {
                    this.$instance = instance;
                    this.$nodeConfig = jiraNodeConfig;
                    this.this$0 = dataCenterFormula;
                    this.$executor$inlined = executorService;
                    this.$keyPath$inlined = path;
                    this.$key$inlined = future;
                    this.$resultsTransport$inlined = storage;
                    this.$databaseMachine$inlined = instance2;
                    this.$pluginsTransport$inlined = storage2;
                    this.$sharedHome$inlined = completableFuture;
                    super(0);
                }

                @NotNull
                public final StoppedNode invoke() {
                    String sshIpAddress;
                    EventBus.INSTANCE.publish((Object)this.$instance);
                    String string = sshIpAddress = this.$instance.getPublicIpAddress();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sshIpAddress");
                    Ssh ssh = new Ssh(new SshHost(string, "ubuntu", this.$keyPath$inlined), 5);
                    ((SshKey)this.$key$inlined.get()).getFile().facilitateSsh(sshIpAddress);
                    String string2 = this.$databaseMachine$inlined.getPrivateIpAddress();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"databaseMachine.privateIpAddress");
                    String string3 = DataCenterFormula.access$getAdminPasswordPlainText$p(this.this$0);
                    Object object = DataCenterFormula.access$getComputer$p(this.this$0);
                    Object object2 = this.$nodeConfig;
                    boolean bl = DataCenterFormula.access$getWaitForUpgrades$p(this.this$0);
                    boolean bl2 = DataCenterFormula.access$getWaitForRunning$p(this.this$0);
                    Ssh ssh2 = ssh;
                    ProductDistribution productDistribution = DataCenterFormula.access$getProductDistribution$p(this.this$0);
                    Storage storage = this.$pluginsTransport$inlined;
                    JiraHomeSource jiraHomeSource = DataCenterFormula.access$getJiraHomeSource$p(this.this$0);
                    String string4 = string2;
                    Storage storage2 = this.$resultsTransport$inlined;
                    StandaloneNodeFormula baseNode = new StandaloneNodeFormula(jiraHomeSource, storage, storage2, string4, productDistribution, ssh2, bl2, bl, (JiraNodeConfig)object2, (Computer)object, string3);
                    NodeFormula nodeFormula = baseNode;
                    Future future = this.$sharedHome$inlined;
                    String string5 = this.$instance.getPrivateIpAddress();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"instance.privateIpAddress");
                    object = string5;
                    object2 = future;
                    NodeFormula nodeFormula2 = nodeFormula;
                    DataCenterNodeFormula dcNode = new DataCenterNodeFormula((Future<SharedHome>)object2, nodeFormula2, (String)object);
                    return new DiagnosableNodeFormula(dcNode).provision();
                }
            }));
            object2.add(object);
        }
        List nodesProvisioning = (List)destination$iv$iv;
        ProvisionedLoadBalancer provisionedLoadBalancer = (ProvisionedLoadBalancer)futureLoadBalancer2.get();
        LoadBalancer loadBalancer = provisionedLoadBalancer.getLoadBalancer();
        SecurityGroup jiraNodeSecurityGroup = jiraStack.findSecurityGroup("JiraNodeSecurityGroup");
        int n = 8080;
        SecurityGroupIngressAccessProvider jiraNodeHttpAccessProvider = new SecurityGroupIngressAccessProvider.Builder(aws.getEc2(), jiraNodeSecurityGroup, new IntRange(n, 8080)).build();
        item$iv$iv2 = this.configs;
        object = multiAccessProvider4;
        object2 = multiAccessProvider4;
        instance = $receiver$iv6;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv6) {
            JiraNodeConfig it2 = (JiraNodeConfig)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it2.getDebug().getRequiredPorts();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Collection<SecurityGroupIngressAccessProvider> collection = (List)destination$iv$iv2;
        $receiver$iv$iv6 = $receiver$iv6 = (Iterable)CollectionsKt.toSet((Iterable)collection);
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv6, (int)10));
        for (Object item$iv$iv3 : $receiver$iv$iv6) {
            int it2 = ((Number)item$iv$iv3).intValue();
            collection = destination$iv$iv2;
            boolean bl = false;
            int list$iv$iv = it2;
            securityGroupIngressAccessProvider = new SecurityGroupIngressAccessProvider.Builder(aws.getEc2(), jiraNodeSecurityGroup, new IntRange(list$iv$iv, it2)).build();
            collection.add(securityGroupIngressAccessProvider);
        }
        collection = (List)destination$iv$iv2;
        ((MultiAccessProvider)object)((List<? extends AccessProvider>)collection);
        Object jiraNodeJvmDebugAccessProvider = object2;
        $receiver$iv$iv6 = this.configs;
        object = multiAccessProvider3;
        object2 = multiAccessProvider3;
        destination$iv$iv2 = $receiver$iv5;
        Collection destination$iv$iv3 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv5) {
            JiraNodeConfig it3 = (JiraNodeConfig)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it3.getRemoteJmx().getRequiredPorts();
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        collection = (List)destination$iv$iv3;
        $receiver$iv$iv5 = $receiver$iv5 = (Iterable)CollectionsKt.toSet((Iterable)collection);
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv5, (int)10));
        for (Object item$iv$iv4 : $receiver$iv$iv5) {
            int it3 = ((Number)item$iv$iv4).intValue();
            collection = destination$iv$iv3;
            boolean bl = false;
            int list$iv$iv = it3;
            securityGroupIngressAccessProvider = new SecurityGroupIngressAccessProvider.Builder(aws.getEc2(), jiraNodeSecurityGroup, new IntRange(list$iv$iv, it3)).build();
            collection.add(securityGroupIngressAccessProvider);
        }
        collection = (List)destination$iv$iv3;
        ((MultiAccessProvider)object)((List<? extends AccessProvider>)collection);
        Object jiraNodeJmxAccessProvider = object2;
        $receiver$iv$iv5 = this.configs;
        object = multiAccessProvider2;
        object2 = multiAccessProvider2;
        destination$iv$iv3 = $receiver$iv4;
        Collection destination$iv$iv4 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv4) {
            JiraNodeConfig it4 = (JiraNodeConfig)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it4.getSplunkForwarder().getRequiredPorts();
            CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
        }
        collection = (List)destination$iv$iv4;
        $receiver$iv$iv4 = $receiver$iv4 = (Iterable)CollectionsKt.toSet((Iterable)collection);
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv4, (int)10));
        for (Object item$iv$iv5 : $receiver$iv$iv4) {
            int it4 = ((Number)item$iv$iv5).intValue();
            collection = destination$iv$iv4;
            boolean bl = false;
            int list$iv$iv = it4;
            securityGroupIngressAccessProvider = new SecurityGroupIngressAccessProvider.Builder(aws.getEc2(), jiraNodeSecurityGroup, new IntRange(list$iv$iv, it4)).build();
            collection.add(securityGroupIngressAccessProvider);
        }
        collection = (List)destination$iv$iv4;
        ((MultiAccessProvider)object)((List<? extends AccessProvider>)collection);
        Object jiraNodeSplunkForwarderAccessProvider = object2;
        $receiver$iv$iv4 = SetsKt.setOf((Object[])new Integer[]{40001, 40011});
        object = multiAccessProvider;
        object2 = multiAccessProvider;
        destination$iv$iv4 = $receiver$iv3;
        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
        for (Object item$iv$iv6 : $receiver$iv$iv3) {
            void it5;
            int bl = ((Number)item$iv$iv6).intValue();
            collection = destination$iv$iv5;
            boolean bl2 = false;
            void $i$f$mapTo = it5;
            securityGroupIngressAccessProvider = new SecurityGroupIngressAccessProvider.Builder(aws.getEc2(), jiraNodeSecurityGroup, new IntRange((int)$i$f$mapTo, (int)it5)).build();
            collection.add(securityGroupIngressAccessProvider);
        }
        collection = (List)destination$iv$iv5;
        ((MultiAccessProvider)object)((List<? extends AccessProvider>)collection);
        Object jiraNodeRmiAccessProvider = object2;
        MultiAccessProvider jiraAccessProvider = new MultiAccessProvider(CollectionsKt.listOf((Object[])new AccessProvider[]{provisionedLoadBalancer.getAccessProvider(), jiraNodeHttpAccessProvider, (AccessProvider)jiraNodeJvmDebugAccessProvider, (AccessProvider)jiraNodeJmxAccessProvider, (AccessProvider)jiraNodeSplunkForwarderAccessProvider}));
        CompletableFuture rmiNodePublicAccess2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"rmi node public access", (Function0)((Function0)new Function0<Boolean>(jiraNodes, (MultiAccessProvider)jiraNodeRmiAccessProvider){
            final /* synthetic */ List $jiraNodes;
            final /* synthetic */ MultiAccessProvider $jiraNodeRmiAccessProvider;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke() {
                void var3_5;
                Collection<ForIpAccessRequester> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                MultiAccessRequester multiAccessRequester;
                Iterable iterable = this.$jiraNodes;
                MultiAccessRequester multiAccessRequester2 = multiAccessRequester;
                MultiAccessRequester multiAccessRequester3 = multiAccessRequester;
                void var2_4 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    Instance instance = (Instance)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    ForIpAccessRequester forIpAccessRequester = new ForIpAccessRequester(new Supplier<String>((Instance)it){
                        final /* synthetic */ Instance $it;

                        public final String get() {
                            return this.$it.getPublicIpAddress();
                        }
                        {
                            this.$it = instance;
                        }
                    });
                    collection.add(forIpAccessRequester);
                }
                collection = (List)var3_5;
                multiAccessRequester2((List<? extends AccessRequester>)collection);
                return multiAccessRequester3.requestAccess(this.$jiraNodeRmiAccessProvider);
            }
            {
                this.$jiraNodes = list;
                this.$jiraNodeRmiAccessProvider = multiAccessProvider;
                super(0);
            }
        }));
        CompletableFuture selfDashboardAccess2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"self dashboard access", (Function0)((Function0)new Function0<Boolean>(jiraNodes, provisionedLoadBalancer){
            final /* synthetic */ List $jiraNodes;
            final /* synthetic */ ProvisionedLoadBalancer $provisionedLoadBalancer;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke() {
                void var3_5;
                Collection<ForIpAccessRequester> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                MultiAccessRequester multiAccessRequester;
                Iterable iterable = this.$jiraNodes;
                MultiAccessRequester multiAccessRequester2 = multiAccessRequester;
                MultiAccessRequester multiAccessRequester3 = multiAccessRequester;
                void var2_4 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    Instance instance = (Instance)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    ForIpAccessRequester forIpAccessRequester = new ForIpAccessRequester(new Supplier<String>((Instance)it){
                        final /* synthetic */ Instance $it;

                        public final String get() {
                            return this.$it.getPublicIpAddress();
                        }
                        {
                            this.$it = instance;
                        }
                    });
                    collection.add(forIpAccessRequester);
                }
                collection = (List)var3_5;
                multiAccessRequester2((List<? extends AccessRequester>)collection);
                return multiAccessRequester3.requestAccess(this.$provisionedLoadBalancer.getAccessProvider());
            }
            {
                this.$jiraNodes = list;
                this.$provisionedLoadBalancer = provisionedLoadBalancer;
                super(0);
            }
        }));
        CompletableFuture loadBalancerAccess2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"load balancer access", (Function0)((Function0)new Function0<Boolean>(provisionedLoadBalancer, jiraNodeHttpAccessProvider){
            final /* synthetic */ ProvisionedLoadBalancer $provisionedLoadBalancer;
            final /* synthetic */ SecurityGroupIngressAccessProvider $jiraNodeHttpAccessProvider;

            public final boolean invoke() {
                return this.$provisionedLoadBalancer.getAccessRequester().requestAccess(this.$jiraNodeHttpAccessProvider);
            }
            {
                this.$provisionedLoadBalancer = provisionedLoadBalancer;
                this.$jiraNodeHttpAccessProvider = securityGroupIngressAccessProvider;
                super(0);
            }
        }));
        CompletableFuture externalAccess2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"external access", (Function0)((Function0)new Function0<Boolean>(this, jiraAccessProvider){
            final /* synthetic */ DataCenterFormula this$0;
            final /* synthetic */ MultiAccessProvider $jiraAccessProvider;

            public final boolean invoke() {
                return DataCenterFormula.access$getAccessRequester$p(this.this$0).requestAccess(this.$jiraAccessProvider);
            }
            {
                this.this$0 = dataCenterFormula;
                this.$jiraAccessProvider = multiAccessProvider;
                super(0);
            }
        }));
        CompletableFuture setupDatabase2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"database", (Function0)((Function0)new Function0<RemoteLocation>(this, databaseMachine, keyPath, key, loadBalancer){
            final /* synthetic */ DataCenterFormula this$0;
            final /* synthetic */ Instance $databaseMachine;
            final /* synthetic */ Path $keyPath;
            final /* synthetic */ Future $key;
            final /* synthetic */ LoadBalancer $loadBalancer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final RemoteLocation invoke() {
                RemoteLocation remoteLocation;
                String databaseSshIp;
                EventBus.INSTANCE.publish((Object)this.$databaseMachine);
                String string = databaseSshIp = this.$databaseMachine.getPublicIpAddress();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"databaseSshIp");
                Ssh databaseSsh = new Ssh(new SshHost(string, "ubuntu", this.$keyPath), 5);
                ((SshKey)this.$key.get()).getFile().facilitateSsh(databaseSshIp);
                Closeable closeable = (Closeable)databaseSsh.newConnection();
                Throwable throwable = null;
                try {
                    SshConnection it = (SshConnection)closeable;
                    boolean bl = false;
                    DataCenterFormula.access$getDatabaseComputer$p(this.this$0).setUp$aws_infrastructure(it);
                    DataCenterFormula.access$getLogger$p(this.this$0).info("Setting up database...");
                    String databaseDataLocation = DataCenterFormula.access$getDatabase$p(this.this$0).setup(it);
                    DataCenterFormula.access$getLogger$p(this.this$0).info("Database is set up");
                    DataCenterFormula.access$getLogger$p(this.this$0).info("Starting database...");
                    DataCenterFormula.access$getDatabase$p(this.this$0).start(this.$loadBalancer.getUri(), it);
                    DataCenterFormula.access$getLogger$p(this.this$0).info("Database is started");
                    remoteLocation = new RemoteLocation(databaseSsh.getHost(), databaseDataLocation);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return remoteLocation;
            }
            {
                this.this$0 = dataCenterFormula;
                this.$databaseMachine = instance;
                this.$keyPath = path;
                this.$key = future;
                this.$loadBalancer = loadBalancer;
                super(0);
            }
        }));
        RemoteLocation databaseDataLocation = (RemoteLocation)setupDatabase2.get();
        List updateJiraConfiguration2 = loadBalancer instanceof ApacheProxyLoadBalancer ? CollectionsKt.listOf((Object)new Function2<Ssh, String, Unit>(loadBalancer){

            public final void invoke(@NotNull Ssh p1, @NotNull String p2) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                ((ApacheProxyLoadBalancer)((LoadBalancer)this.receiver)).updateJiraConfiguration(p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ApacheProxyLoadBalancer.class);
            }

            public final String getName() {
                return "updateJiraConfiguration";
            }

            public final String getSignature() {
                return "updateJiraConfiguration(Lcom/atlassian/performance/tools/ssh/api/Ssh;Ljava/lang/String;)V";
            }
        }) : CollectionsKt.emptyList();
        Iterable $i$f$map = nodesProvisioning;
        DependentResources dependentResources = $receiver$iv2;
        Collection destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv7 : $receiver$iv$iv2) {
            CompletableFuture completableFuture = (CompletableFuture)item$iv$iv7;
            object2 = destination$iv$iv6;
            boolean bl = false;
            object = (StoppedNode)((CompletableFuture)((Object)it)).get();
            object2.add(object);
        }
        $receiver$iv2 = (List)destination$iv$iv6;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv7 : $receiver$iv$iv2) {
            void node2;
            it = (StoppedNode)item$iv$iv7;
            object2 = destination$iv$iv6;
            boolean bl = false;
            object = (StartedNode)TaskScope.INSTANCE.task("start " + node2, (Callable)new Callable<StartedNode>((StoppedNode)node2, updateJiraConfiguration2){
                final /* synthetic */ StoppedNode $node;
                final /* synthetic */ List $updateJiraConfiguration$inlined;
                {
                    this.$node = stoppedNode;
                    this.$updateJiraConfiguration$inlined = list;
                }

                @NotNull
                public final StartedNode call() {
                    return this.$node.start(this.$updateJiraConfiguration$inlined);
                }
            });
            object2.add(object);
        }
        List nodes = (List)destination$iv$iv6;
        if (!((Boolean)rmiNodePublicAccess2.get()).booleanValue()) {
            this.logger.warn("Jira nodes may not have access to other nodes RMI ports. This can cause slow Jira startup.");
        }
        if (!((Boolean)selfDashboardAccess2.get()).booleanValue()) {
            this.logger.warn("It's possible that Jira nodes don't have HTTP access to the load balancer. Dashboards may not work.");
        }
        if (!((Boolean)loadBalancerAccess2.get()).booleanValue()) {
            this.logger.warn("Load balancer may not have access to Jira nodes");
        }
        if (!((Boolean)externalAccess2.get()).booleanValue()) {
            this.logger.warn("It's possible that defined external access to Jira resources (e.g. http, debug, splunk) wasn't granted.");
        }
        executor.shutdownNow();
        TaskScope.INSTANCE.task("wait for loadbalancer", (Callable)new Callable<Unit>(loadBalancer){
            final /* synthetic */ LoadBalancer $loadBalancer;

            public final void call() {
                Duration duration = Duration.ofMinutes(5L);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(5)");
                this.$loadBalancer.waitUntilHealthy(duration);
            }
            {
                this.$loadBalancer = loadBalancer;
            }
        });
        RemoteLocation remoteLocation = new RemoteLocation(sharedHomeSshHost, ((SharedHome)sharedHome2.get()).getRemoteSharedHome());
        RemoteLocation remoteLocation2 = databaseDataLocation;
        Intrinsics.checkExpressionValueIsNotNull((Object)remoteLocation2, (String)"databaseDataLocation");
        $receiver$iv$iv2 = jiraNodes;
        object2 = new Jira.Builder(nodes, remoteLocation, remoteLocation2, loadBalancer.getUri());
        destination$iv$iv6 = $receiver$iv;
        Collection destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv2 = 0;
        for (Object item$iv$iv8 : $receiver$iv$iv) {
            void node3;
            void i;
            int n3 = index$iv$iv2++;
            Instance $i$f$mapTo = (Instance)item$iv$iv8;
            int $i$f$map2 = n3;
            object = destination$iv$iv7;
            boolean bl = false;
            RemoteJmx remoteJmx = this.configs.get((int)i).getRemoteJmx();
            String string2 = node3.getPublicIpAddress();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"node.publicIpAddress");
            collection = remoteJmx.getClient(string2);
            object.add(collection);
        }
        object = (List)destination$iv$iv7;
        Jira jira = ((Jira.Builder)object2).jmxClients((List<? extends JmxClient>)object).build();
        this.logger.info(jira + " is set up, will expire " + jiraStack.getExpiry());
        ProvisionedJira.Builder builder = new ProvisionedJira.Builder(jira);
        Resource resource = provisionedLoadBalancer.getResource();
        ProvisionedStack provisionedStack = jiraStack;
        Intrinsics.checkExpressionValueIsNotNull((Object)provisionedStack, (String)"jiraStack");
        $receiver$iv$iv = dependentResources = new DependentResources(resource, (Resource)provisionedStack);
        object2 = builder;
        boolean bl = false;
        object = new DependentResources((Resource)instances, provisionedNetwork2.getResource());
        return ((ProvisionedJira.Builder)object2).resource((Resource)object).accessProvider(jiraAccessProvider).build();
    }

    private DataCenterFormula(List<JiraNodeConfig> configs, LoadBalancerFormula loadBalancerFormula, Apps apps, ProductDistribution productDistribution, JiraHomeSource jiraHomeSource, Database database, Computer computer, Volume jiraVolume, Duration stackCreationTimeout, Network overriddenNetwork, Computer databaseComputer, Volume databaseVolume, AccessRequester accessRequester, String adminPasswordPlainText, boolean waitForRunning2, boolean waitForUpgrades) {
        this.configs = configs;
        this.loadBalancerFormula = loadBalancerFormula;
        this.apps = apps;
        this.productDistribution = productDistribution;
        this.jiraHomeSource = jiraHomeSource;
        this.database = database;
        this.computer = computer;
        this.jiraVolume = jiraVolume;
        this.stackCreationTimeout = stackCreationTimeout;
        this.overriddenNetwork = overriddenNetwork;
        this.databaseComputer = databaseComputer;
        this.databaseVolume = databaseVolume;
        this.accessRequester = accessRequester;
        this.adminPasswordPlainText = adminPasswordPlainText;
        this.waitForRunning = waitForRunning2;
        this.waitForUpgrades = waitForUpgrades;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }

    /* synthetic */ DataCenterFormula(List list, LoadBalancerFormula loadBalancerFormula, Apps apps, ProductDistribution productDistribution, JiraHomeSource jiraHomeSource, Database database, Computer computer, Volume volume, Duration duration, Network network, Computer computer2, Volume volume2, AccessRequester accessRequester, String string, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x200) != 0) {
            network = null;
        }
        this(list, loadBalancerFormula, apps, productDistribution, jiraHomeSource, database, computer, volume, duration, network, computer2, volume2, accessRequester, string, bl, bl2);
    }

    public /* synthetic */ DataCenterFormula(List configs, LoadBalancerFormula loadBalancerFormula, Apps apps, ProductDistribution productDistribution, JiraHomeSource jiraHomeSource, Database database, Computer computer, Volume jiraVolume, Duration stackCreationTimeout, Network overriddenNetwork, Computer databaseComputer, Volume databaseVolume, AccessRequester accessRequester, String adminPasswordPlainText, boolean waitForRunning2, boolean waitForUpgrades, DefaultConstructorMarker $constructor_marker) {
        this(configs, loadBalancerFormula, apps, productDistribution, jiraHomeSource, database, computer, jiraVolume, stackCreationTimeout, overriddenNetwork, databaseComputer, databaseVolume, accessRequester, adminPasswordPlainText, waitForRunning2, waitForUpgrades);
    }

    public static final /* synthetic */ Logger access$getLogger$p(DataCenterFormula $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010$\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\u00020\u00002\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0013J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0019J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u0015\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b%J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\"R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/DataCenterFormula$Builder;", "", "formula", "Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/DataCenterFormula;", "(Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/DataCenterFormula;)V", "productDistribution", "Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;", "jiraHomeSource", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;", "database", "Lcom/atlassian/performance/tools/infrastructure/api/database/Database;", "(Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;Lcom/atlassian/performance/tools/infrastructure/api/database/Database;)V", "accessRequester", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/access/AccessRequester;", "adminPasswordPlainText", "", "apps", "Lcom/atlassian/performance/tools/infrastructure/api/app/Apps;", "computer", "Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Computer;", "configs", "", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraNodeConfig;", "databaseComputer", "databaseVolume", "Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Volume;", "jiraVolume", "loadBalancerFormula", "Lcom/atlassian/performance/tools/awsinfrastructure/api/loadbalancer/LoadBalancerFormula;", "network", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/Network;", "stackCreationTimeout", "Ljava/time/Duration;", "waitForRunning", "", "waitForUpgrades", "build", "network$aws_infrastructure", "aws-infrastructure"})
    public static final class Builder {
        private List<JiraNodeConfig> configs;
        private LoadBalancerFormula loadBalancerFormula;
        private Apps apps;
        private Computer computer;
        private Volume jiraVolume;
        private Duration stackCreationTimeout;
        private Network network;
        private Computer databaseComputer;
        private Volume databaseVolume;
        private AccessRequester accessRequester;
        private String adminPasswordPlainText;
        private boolean waitForRunning;
        private boolean waitForUpgrades;
        private final ProductDistribution productDistribution;
        private final JiraHomeSource jiraHomeSource;
        private final Database database;

        @NotNull
        public final Builder configs(@NotNull List<JiraNodeConfig> configs) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull(configs, (String)"configs");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.configs = configs;
            return builder;
        }

        @NotNull
        public final Builder loadBalancerFormula(@NotNull LoadBalancerFormula loadBalancerFormula) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)loadBalancerFormula, (String)"loadBalancerFormula");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.loadBalancerFormula = loadBalancerFormula;
            return builder;
        }

        @NotNull
        public final Builder apps(@NotNull Apps apps) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)apps, (String)"apps");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.apps = apps;
            return builder;
        }

        @NotNull
        public final Builder computer(@NotNull Computer computer) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)computer, (String)"computer");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.computer = computer;
            return builder;
        }

        @NotNull
        public final Builder jiraVolume(@NotNull Volume jiraVolume) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)jiraVolume, (String)"jiraVolume");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.jiraVolume = jiraVolume;
            return builder;
        }

        @NotNull
        public final Builder stackCreationTimeout(@NotNull Duration stackCreationTimeout) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)stackCreationTimeout, (String)"stackCreationTimeout");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.stackCreationTimeout = stackCreationTimeout;
            return builder;
        }

        @NotNull
        public final Builder databaseComputer(@NotNull Computer databaseComputer) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)databaseComputer, (String)"databaseComputer");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.databaseComputer = databaseComputer;
            return builder;
        }

        @NotNull
        public final Builder databaseVolume(@NotNull Volume databaseVolume) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)databaseVolume, (String)"databaseVolume");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.databaseVolume = databaseVolume;
            return builder;
        }

        @NotNull
        public final Builder adminPasswordPlainText(@NotNull String adminPasswordPlainText) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)adminPasswordPlainText, (String)"adminPasswordPlainText");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.adminPasswordPlainText = adminPasswordPlainText;
            return builder;
        }

        @NotNull
        public final Builder network$aws_infrastructure(@NotNull Network network) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.network = network;
            return builder;
        }

        @NotNull
        public final Builder accessRequester(@NotNull AccessRequester accessRequester) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)accessRequester, (String)"accessRequester");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.accessRequester = accessRequester;
            return builder;
        }

        @NotNull
        public final Builder waitForRunning(boolean waitForRunning2) {
            Builder builder;
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.waitForRunning = waitForRunning2;
            return builder;
        }

        @NotNull
        public final Builder waitForUpgrades(boolean waitForUpgrades) {
            Builder builder;
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.waitForUpgrades = waitForUpgrades;
            return builder;
        }

        @NotNull
        public final DataCenterFormula build() {
            return new DataCenterFormula(this.configs, this.loadBalancerFormula, this.apps, this.productDistribution, this.jiraHomeSource, this.database, this.computer, this.jiraVolume, this.stackCreationTimeout, this.network, this.databaseComputer, this.databaseVolume, this.accessRequester, this.adminPasswordPlainText, this.waitForRunning, this.waitForUpgrades, null);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NotNull ProductDistribution productDistribution, @NotNull JiraHomeSource jiraHomeSource, @NotNull Database database) {
            Collection<JiraNodeConfig> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)productDistribution, (String)"productDistribution");
            Intrinsics.checkParameterIsNotNull((Object)jiraHomeSource, (String)"jiraHomeSource");
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            this.productDistribution = productDistribution;
            this.jiraHomeSource = jiraHomeSource;
            this.database = database;
            int n = 1;
            Iterable iterable = (Iterable)new IntRange(n, 2);
            Builder builder = this;
            void var5_7 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
                collection = destination$iv$iv;
                boolean bl = false;
                JiraNodeConfig jiraNodeConfig = new JiraNodeConfig.Builder().name("jira-node-" + (int)it).build();
                collection.add(jiraNodeConfig);
            }
            collection = (List)destination$iv$iv;
            builder.configs = collection;
            this.loadBalancerFormula = new ApacheEc2LoadBalancerFormula();
            this.apps = new Apps(CollectionsKt.emptyList());
            this.computer = new C4EightExtraLargeElastic();
            this.jiraVolume = new Volume(100);
            Duration duration = Duration.ofMinutes(30L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(30)");
            this.stackCreationTimeout = duration;
            this.databaseComputer = new M4ExtraLargeElastic();
            this.databaseVolume = new Volume(100);
            this.accessRequester = new ForIpAccessRequester(new LocalPublicIpv4Provider.Builder().build());
            this.adminPasswordPlainText = "admin";
            this.waitForUpgrades = true;
        }

        public Builder(@NotNull DataCenterFormula formula) {
            Intrinsics.checkParameterIsNotNull((Object)formula, (String)"formula");
            this(formula.productDistribution, formula.jiraHomeSource, formula.database);
            this.configs = formula.configs;
            this.loadBalancerFormula = formula.loadBalancerFormula;
            this.apps = formula.apps;
            this.computer = formula.computer;
            this.jiraVolume = formula.jiraVolume;
            this.stackCreationTimeout = formula.stackCreationTimeout;
            this.network = formula.overriddenNetwork;
            this.databaseComputer = formula.databaseComputer;
            this.databaseVolume = formula.databaseVolume;
            this.accessRequester = formula.accessRequester;
            this.adminPasswordPlainText = formula.adminPasswordPlainText;
            this.waitForRunning = formula.waitForRunning;
            this.waitForUpgrades = formula.waitForUpgrades;
        }
    }
}

