/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api;

import com.atlassian.performance.tools.aws.api.StorageLocation;
import com.atlassian.performance.tools.awsinfrastructure.api.aws.AwsCli;
import com.atlassian.performance.tools.infrastructure.api.dataset.FileArchiver;
import com.atlassian.performance.tools.ssh.api.Ssh;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import com.atlassian.performance.tools.ssh.api.SshHost;
import java.io.Closeable;
import java.nio.file.Path;
import java.time.Duration;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0019\u001a\u00020\u0003J\b\u0010\u001a\u001a\u00020\bH\u0016J\u0016\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;", "", "json", "Ljavax/json/JsonObject;", "(Ljavax/json/JsonObject;)V", "host", "Lcom/atlassian/performance/tools/ssh/api/SshHost;", "location", "", "(Lcom/atlassian/performance/tools/ssh/api/SshHost;Ljava/lang/String;)V", "getHost", "()Lcom/atlassian/performance/tools/ssh/api/SshHost;", "getLocation", "()Ljava/lang/String;", "logger", "Lorg/apache/logging/log4j/Logger;", "archive", "timeout", "Ljava/time/Duration;", "download", "", "localDestination", "Ljava/nio/file/Path;", "move", "destination", "toJson", "toString", "upload", "storage", "Lcom/atlassian/performance/tools/aws/api/StorageLocation;", "aws-infrastructure"})
public final class RemoteLocation {
    private final Logger logger;
    @NotNull
    private final SshHost host;
    @NotNull
    private final String location;

    @NotNull
    public final JsonObject toJson() {
        JsonObject jsonObject = Json.createObjectBuilder().add("host", (JsonValue)this.host.toJson()).add("location", this.location).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"Json.createObjectBuilder\u2026ion)\n            .build()");
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RemoteLocation move(@NotNull String destination, @NotNull Duration timeout) {
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        if (Intrinsics.areEqual((Object)this.location, (Object)destination) ^ true) {
            Closeable closeable = (Closeable)new Ssh(this.host, 4).newConnection();
            Throwable throwable = null;
            try {
                SshConnection it = (SshConnection)closeable;
                boolean bl = false;
                SshConnection.SshResult sshResult = it.execute("sudo mv " + this.location + ' ' + destination, timeout);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return new RemoteLocation(this.host, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RemoteLocation archive(@NotNull Duration timeout) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        this.logger.info("Archiving " + this.location + "...");
        Closeable closeable = (Closeable)new Ssh(this.host, 4).newConnection();
        Throwable throwable = null;
        try {
            SshConnection it = (SshConnection)closeable;
            boolean bl = false;
            string = FileArchiver.zip$default((FileArchiver)new FileArchiver(), (SshConnection)it, (String)this.location, (Duration)timeout, (int)0, (int)0, (int)24, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String destination = string;
        this.logger.info("Archiving " + this.location + " complete");
        return new RemoteLocation(this.host, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void upload(@NotNull StorageLocation storage, @NotNull Duration timeout) {
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        this.logger.info("Uploading " + this.location + "...");
        Closeable closeable = (Closeable)new Ssh(this.host, 4).newConnection();
        Throwable throwable = null;
        try {
            SshConnection it = (SshConnection)closeable;
            boolean bl = false;
            new AwsCli().uploadFile(storage, it, this.location, timeout);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.logger.info("Uploading " + this.location + " complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void download(@NotNull Path localDestination) {
        Intrinsics.checkParameterIsNotNull((Object)localDestination, (String)"localDestination");
        Closeable closeable = (Closeable)new Ssh(this.host, 4).newConnection();
        Throwable throwable = null;
        try {
            SshConnection it = (SshConnection)closeable;
            boolean bl = false;
            it.download(this.location, localDestination);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public String toString() {
        return "RemoteLocation(host=" + this.host + ", location='" + this.location + "')";
    }

    @NotNull
    public final SshHost getHost() {
        return this.host;
    }

    @NotNull
    public final String getLocation() {
        return this.location;
    }

    public RemoteLocation(@NotNull SshHost host2, @NotNull String location) {
        Intrinsics.checkParameterIsNotNull((Object)host2, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        this.host = host2;
        this.location = location;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }

    public RemoteLocation(@NotNull JsonObject json) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        JsonObject jsonObject = json.getJsonObject("host");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"json.getJsonObject(\"host\")");
        SshHost sshHost = new SshHost(jsonObject);
        String string = json.getString("location");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"json.getString(\"location\")");
        this(sshHost, string);
    }
}

