/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api;

import com.atlassian.performance.tools.aws.api.StorageLocation;
import com.atlassian.performance.tools.awsinfrastructure.api.DatasetCatalogue;
import com.atlassian.performance.tools.awsinfrastructure.api.RemoteLocation;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.StoppableNode;
import com.atlassian.performance.tools.concurrency.api.TaskContextKt;
import com.atlassian.performance.tools.infrastructure.api.dataset.Dataset;
import com.atlassian.performance.tools.ssh.api.Ssh;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import com.atlassian.performance.tools.ssh.api.SshHost;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003 !\"B5\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/CustomDatasetSource;", "", "jiraHome", "Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;", "database", "jiraHomeTimeouts", "Lcom/atlassian/performance/tools/awsinfrastructure/api/CustomDatasetSource$Timeouts;", "databaseTimeouts", "nodes", "", "Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/StoppableNode;", "(Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;Lcom/atlassian/performance/tools/awsinfrastructure/api/CustomDatasetSource$Timeouts;Lcom/atlassian/performance/tools/awsinfrastructure/api/CustomDatasetSource$Timeouts;Ljava/util/List;)V", "getDatabase", "()Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;", "getJiraHome", "logger", "Lorg/apache/logging/log4j/Logger;", "stopDockerContainers", "", "host", "Lcom/atlassian/performance/tools/ssh/api/SshHost;", "stopJira", "store", "Lcom/atlassian/performance/tools/infrastructure/api/dataset/Dataset;", "location", "Lcom/atlassian/performance/tools/aws/api/StorageLocation;", "store$aws_infrastructure", "storeInS3", "toJson", "Ljavax/json/JsonObject;", "toString", "", "Builder", "FileNames", "Timeouts", "aws-infrastructure"})
public final class CustomDatasetSource {
    private final Logger logger;
    @NotNull
    private final RemoteLocation jiraHome;
    @NotNull
    private final RemoteLocation database;
    private final Timeouts jiraHomeTimeouts;
    private final Timeouts databaseTimeouts;
    private final List<StoppableNode> nodes;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JsonObject toJson() {
        void $receiver$iv$iv;
        JsonArrayBuilder jsonArrayBuilder;
        JsonArrayBuilder jsonArrayBuilder2 = jsonArrayBuilder = Json.createArrayBuilder();
        String string = "nodes";
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder().add("jiraHome", (JsonValue)this.jiraHome.toJson()).add("database", (JsonValue)this.database.toJson());
        boolean bl = false;
        Iterable $receiver$iv = this.nodes;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            StoppableNode stoppableNode = (StoppableNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            JsonObject jsonObject = it.toJson();
            collection.add(jsonObject);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            void $receiver;
            JsonObject it = (JsonObject)element$iv;
            boolean bl3 = false;
            $receiver.add((JsonValue)it);
        }
        Unit unit = Unit.INSTANCE;
        JsonObject jsonObject = jsonObjectBuilder.add(string, (JsonValue)jsonArrayBuilder.build()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"Json.createObjectBuilder\u2026d())\n            .build()");
        return jsonObject;
    }

    public final void storeInS3(@NotNull StorageLocation location) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        this.store$aws_infrastructure(location);
    }

    @NotNull
    public final Dataset store$aws_infrastructure(@NotNull StorageLocation location) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        this.logger.info("Uploading dataset to '" + location + "'...");
        ExecutorService executor = Executors.newFixedThreadPool(3, new ThreadFactoryBuilder().setNameFormat("s3-upload-thread-%d").build());
        this.stopJira();
        this.stopDockerContainers(this.database.getHost());
        ExecutorService executorService = executor;
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"executor");
        CompletableFuture jiraHomeUpload2 = TaskContextKt.submitWithLogContext((ExecutorService)executorService, (String)"jiraHome", (Function0)((Function0)new Function0<Unit>(this, location){
            final /* synthetic */ CustomDatasetSource this$0;
            final /* synthetic */ StorageLocation $location;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                RemoteLocation remoteLocation = this.this$0.getJiraHome();
                Duration duration = Duration.ofMinutes(1L);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(1)");
                RemoteLocation renamed = remoteLocation.move("jirahome", duration);
                try {
                    renamed.archive(CustomDatasetSource.access$getJiraHomeTimeouts$p(this.this$0).getArchive()).upload(this.$location, CustomDatasetSource.access$getJiraHomeTimeouts$p(this.this$0).getUpload());
                }
                finally {
                    renamed.move(this.this$0.getJiraHome().getLocation(), CustomDatasetSource.access$getJiraHomeTimeouts$p(this.this$0).getMove());
                }
            }
            {
                this.this$0 = customDatasetSource;
                this.$location = storageLocation;
                super(0);
            }
        }));
        CompletableFuture databaseUpload2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"database", (Function0)((Function0)new Function0<Unit>(this, location){
            final /* synthetic */ CustomDatasetSource this$0;
            final /* synthetic */ StorageLocation $location;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                RemoteLocation remoteLocation = this.this$0.getDatabase();
                Duration duration = Duration.ofMinutes(1L);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(1)");
                RemoteLocation renamed = remoteLocation.move("database", duration);
                try {
                    renamed.archive(CustomDatasetSource.access$getDatabaseTimeouts$p(this.this$0).getArchive()).upload(this.$location, CustomDatasetSource.access$getDatabaseTimeouts$p(this.this$0).getUpload());
                }
                finally {
                    renamed.move(this.this$0.getDatabase().getLocation(), CustomDatasetSource.access$getDatabaseTimeouts$p(this.this$0).getMove());
                }
            }
            {
                this.this$0 = customDatasetSource;
                this.$location = storageLocation;
                super(0);
            }
        }));
        jiraHomeUpload2.get();
        databaseUpload2.get();
        executor.shutdownNow();
        String locationSnippet = location.toKotlinCodeSnippet();
        this.logger.info("Dataset saved. You can use it via `DatasetCatalogue().custom(" + locationSnippet + ")`");
        return DatasetCatalogue.custom$default(new DatasetCatalogue(), location, null, null, null, 14, null);
    }

    private final void stopJira() {
        Iterable $receiver$iv = this.nodes;
        for (Object element$iv : $receiver$iv) {
            StoppableNode it = (StoppableNode)element$iv;
            boolean bl = false;
            it.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stopDockerContainers(SshHost host2) {
        Closeable closeable = (Closeable)new Ssh(host2, 4).newConnection();
        Throwable throwable = null;
        try {
            SshConnection it = (SshConnection)closeable;
            boolean bl = false;
            SshConnection.SshResult sshResult = it.execute("sudo docker stop $(sudo docker ps -aq)");
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public String toString() {
        return "CustomDatasetSource(jiraHome=" + this.jiraHome + ", database=" + this.database + ')';
    }

    @NotNull
    public final RemoteLocation getJiraHome() {
        return this.jiraHome;
    }

    @NotNull
    public final RemoteLocation getDatabase() {
        return this.database;
    }

    private CustomDatasetSource(RemoteLocation jiraHome, RemoteLocation database, Timeouts jiraHomeTimeouts, Timeouts databaseTimeouts, List<StoppableNode> nodes) {
        this.jiraHome = jiraHome;
        this.database = database;
        this.jiraHomeTimeouts = jiraHomeTimeouts;
        this.databaseTimeouts = databaseTimeouts;
        this.nodes = nodes;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }

    public /* synthetic */ CustomDatasetSource(RemoteLocation jiraHome, RemoteLocation database, Timeouts jiraHomeTimeouts, Timeouts databaseTimeouts, List nodes, DefaultConstructorMarker $constructor_marker) {
        this(jiraHome, database, jiraHomeTimeouts, databaseTimeouts, nodes);
    }

    public static final /* synthetic */ Timeouts access$getJiraHomeTimeouts$p(CustomDatasetSource $this) {
        return $this.jiraHomeTimeouts;
    }

    public static final /* synthetic */ Timeouts access$getDatabaseTimeouts$p(CustomDatasetSource $this) {
        return $this.databaseTimeouts;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/CustomDatasetSource$FileNames;", "", "()V", "DATABASE", "", "JIRAHOME", "aws-infrastructure"})
    public static final class FileNames {
        @NotNull
        public static final String DATABASE = "database";
        @NotNull
        public static final String JIRAHOME = "jirahome";
        @NotNull
        public static final FileNames INSTANCE;

        private FileNames() {
        }

        static {
            FileNames fileNames;
            INSTANCE = fileNames = new FileNames();
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/CustomDatasetSource$Timeouts;", "", "archive", "Ljava/time/Duration;", "upload", "move", "(Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;)V", "getArchive", "()Ljava/time/Duration;", "getMove", "getUpload", "aws-infrastructure"})
    private static final class Timeouts {
        @NotNull
        private final Duration archive;
        @NotNull
        private final Duration upload;
        @NotNull
        private final Duration move;

        @NotNull
        public final Duration getArchive() {
            return this.archive;
        }

        @NotNull
        public final Duration getUpload() {
            return this.upload;
        }

        @NotNull
        public final Duration getMove() {
            return this.move;
        }

        public Timeouts(@NotNull Duration archive, @NotNull Duration upload, @NotNull Duration move) {
            Intrinsics.checkParameterIsNotNull((Object)archive, (String)"archive");
            Intrinsics.checkParameterIsNotNull((Object)upload, (String)"upload");
            Intrinsics.checkParameterIsNotNull((Object)move, (String)"move");
            this.archive = archive;
            this.upload = upload;
            this.move = move;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B#\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\rJ\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\rJ\u0014\u0010\b\u001a\u00020\u00002\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/CustomDatasetSource$Builder;", "", "json", "Ljavax/json/JsonObject;", "(Ljavax/json/JsonObject;)V", "jiraHome", "Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;", "database", "nodes", "", "Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/StoppableNode;", "(Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;Ljava/util/List;)V", "databaseArchiveTimeout", "Ljava/time/Duration;", "databaseMoveTimeout", "databaseUploadTimeout", "jiraHomeArchiveTimeout", "jiraHomeMoveTimeout", "jiraHomeUploadTimeout", "build", "Lcom/atlassian/performance/tools/awsinfrastructure/api/CustomDatasetSource;", "aws-infrastructure"})
    public static final class Builder {
        private Duration jiraHomeArchiveTimeout;
        private Duration jiraHomeUploadTimeout;
        private Duration jiraHomeMoveTimeout;
        private Duration databaseArchiveTimeout;
        private Duration databaseUploadTimeout;
        private Duration databaseMoveTimeout;
        private RemoteLocation jiraHome;
        private RemoteLocation database;
        private List<StoppableNode> nodes;

        @NotNull
        public final Builder jiraHome(@NotNull RemoteLocation jiraHome) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)jiraHome, (String)"jiraHome");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.jiraHome = jiraHome;
            return builder;
        }

        @NotNull
        public final Builder database(@NotNull RemoteLocation database) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.database = database;
            return builder;
        }

        @NotNull
        public final Builder jiraHomeArchiveTimeout(@NotNull Duration jiraHomeArchiveTimeout) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)jiraHomeArchiveTimeout, (String)"jiraHomeArchiveTimeout");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.jiraHomeArchiveTimeout = jiraHomeArchiveTimeout;
            return builder;
        }

        @NotNull
        public final Builder jiraHomeUploadTimeout(@NotNull Duration jiraHomeUploadTimeout) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)jiraHomeUploadTimeout, (String)"jiraHomeUploadTimeout");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.jiraHomeUploadTimeout = jiraHomeUploadTimeout;
            return builder;
        }

        @NotNull
        public final Builder jiraHomeMoveTimeout(@NotNull Duration jiraHomeMoveTimeout) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)jiraHomeMoveTimeout, (String)"jiraHomeMoveTimeout");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.jiraHomeMoveTimeout = jiraHomeMoveTimeout;
            return builder;
        }

        @NotNull
        public final Builder databaseArchiveTimeout(@NotNull Duration databaseArchiveTimeout) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)databaseArchiveTimeout, (String)"databaseArchiveTimeout");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.databaseArchiveTimeout = databaseArchiveTimeout;
            return builder;
        }

        @NotNull
        public final Builder databaseUploadTimeout(@NotNull Duration databaseUploadTimeout) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)databaseUploadTimeout, (String)"databaseUploadTimeout");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.databaseUploadTimeout = databaseUploadTimeout;
            return builder;
        }

        @NotNull
        public final Builder databaseMoveTimeout(@NotNull Duration databaseMoveTimeout) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)databaseMoveTimeout, (String)"databaseMoveTimeout");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.databaseMoveTimeout = databaseMoveTimeout;
            return builder;
        }

        @NotNull
        public final Builder nodes(@NotNull List<StoppableNode> nodes) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull(nodes, (String)"nodes");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.nodes = nodes;
            return builder;
        }

        @NotNull
        public final CustomDatasetSource build() {
            return new CustomDatasetSource(this.jiraHome, this.database, new Timeouts(this.jiraHomeArchiveTimeout, this.jiraHomeUploadTimeout, this.jiraHomeMoveTimeout), new Timeouts(this.databaseArchiveTimeout, this.databaseUploadTimeout, this.databaseMoveTimeout), this.nodes, null);
        }

        public Builder(@NotNull RemoteLocation jiraHome, @NotNull RemoteLocation database, @NotNull List<StoppableNode> nodes) {
            Intrinsics.checkParameterIsNotNull((Object)jiraHome, (String)"jiraHome");
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            Intrinsics.checkParameterIsNotNull(nodes, (String)"nodes");
            this.jiraHome = jiraHome;
            this.database = database;
            this.nodes = nodes;
            Duration duration = Duration.ofMinutes(25L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(25)");
            this.jiraHomeArchiveTimeout = duration;
            Duration duration2 = Duration.ofMinutes(10L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofMinutes(10)");
            this.jiraHomeUploadTimeout = duration2;
            Duration duration3 = Duration.ofMinutes(1L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"Duration.ofMinutes(1)");
            this.jiraHomeMoveTimeout = duration3;
            Duration duration4 = Duration.ofMinutes(25L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration4, (String)"Duration.ofMinutes(25)");
            this.databaseArchiveTimeout = duration4;
            Duration duration5 = Duration.ofMinutes(10L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration5, (String)"Duration.ofMinutes(10)");
            this.databaseUploadTimeout = duration5;
            Duration duration6 = Duration.ofMinutes(1L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration6, (String)"Duration.ofMinutes(1)");
            this.databaseMoveTimeout = duration6;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NotNull JsonObject json) {
            Collection<StoppableNode> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            JsonObject jsonObject = json.getJsonObject("jiraHome");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"json.getJsonObject(\"jiraHome\")");
            RemoteLocation remoteLocation = new RemoteLocation(jsonObject);
            JsonObject jsonObject2 = json.getJsonObject("database");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject2, (String)"json.getJsonObject(\"database\")");
            RemoteLocation remoteLocation2 = new RemoteLocation(jsonObject2);
            JsonArray jsonArray = json.getJsonArray("nodes");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"json.getJsonArray(\"nodes\")");
            Iterable iterable = (Iterable)jsonArray;
            RemoteLocation remoteLocation3 = remoteLocation2;
            RemoteLocation remoteLocation4 = remoteLocation;
            Builder builder = this;
            void var3_6 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                JsonValue jsonValue = (JsonValue)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                JsonObject jsonObject3 = it.asJsonObject();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject3, (String)"it.asJsonObject()");
                StoppableNode stoppableNode = new StoppableNode.Builder(jsonObject3).build();
                collection.add(stoppableNode);
            }
            collection = (List)destination$iv$iv;
            builder(remoteLocation4, remoteLocation3, (List<StoppableNode>)collection);
        }
    }
}

