package com.atlassian.performance.seleniumjs

import org.openqa.selenium.By

class LocatorConverters {
    companion object {
        fun toNativeBy(by: By) : NativeBy {
            return when (by) {
                is By.ById -> NativeBy.id(extractProperty(by, "id"))
                is By.ByClassName -> NativeBy.className(extractProperty(by, "className"))
                is By.ByCssSelector -> NativeBy.cssSelector(extractCssSelector(by))
                else -> throw IllegalArgumentException("Don't know how to handle conversion of " + by + " " + by.javaClass)
            }
        }

        private fun extractCssSelector(by: By.ByCssSelector): String {
            return try {
                extractProperty(by, "cssSelector") //3.141
            } catch (e : NoSuchFieldException) {
                extractProperty(by, "selector") //3.11
            }
        }

        private fun extractProperty(obj: By, name: String) : String {
            val field = obj.javaClass.getDeclaredField(name)
            field.isAccessible = true
            return field.get(obj) as String
        }
    }
}
