/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.querydsl.binding;

import com.querydsl.core.types.Path;
import java.beans.PropertyDescriptor;
import lombok.Generated;
import org.springframework.beans.BeanUtils;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.querydsl.binding.PathInformation;
import org.springframework.lang.Nullable;

class QuerydslPathInformation
implements PathInformation {
    private final Path<?> path;

    @Override
    public Class<?> getLeafType() {
        return this.path.getType();
    }

    @Override
    public Class<?> getLeafParentType() {
        Path<?> parent = this.path.getMetadata().getParent();
        if (parent == null) {
            throw new IllegalStateException(String.format("Could not obtain metadata for parent node of %s!", this.path));
        }
        return parent.getType();
    }

    @Override
    public String getLeafProperty() {
        return this.path.getMetadata().getElement().toString();
    }

    @Override
    @Nullable
    public PropertyDescriptor getLeafPropertyDescriptor() {
        return BeanUtils.getPropertyDescriptor(this.getLeafParentType(), (String)this.getLeafProperty());
    }

    @Override
    public String toDotPath() {
        return QuerydslUtils.toDotPath(this.path);
    }

    @Override
    public Path<?> reifyPath(EntityPathResolver resolver) {
        return this.path;
    }

    @Generated
    public String toString() {
        return "QuerydslPathInformation(path=" + this.path + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuerydslPathInformation)) {
            return false;
        }
        QuerydslPathInformation other = (QuerydslPathInformation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Path<?> this$path = this.path;
        Path<?> other$path = other.path;
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QuerydslPathInformation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Path<?> $path = this.path;
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    @Generated
    private QuerydslPathInformation(Path<?> path) {
        this.path = path;
    }

    @Generated
    public static QuerydslPathInformation of(Path<?> path) {
        return new QuerydslPathInformation(path);
    }
}

