package com.atlassian.paddle.task;

import com.atlassian.paddle.connection.ConnectionException;

import java.util.Iterator;

/**
 * Runs LDAP tasks for testing.
 */
public interface TaskRunner
{
    /**
     * Run a task against the LDAP server.
     *
     * @param task a task to perform
     * @param countLimit how many results to return
     * @throws ConnectionException if there was an error connecting to the server
     */
    void runTask(Task task, long countLimit) throws ConnectionException;

    /**
     * Returns <tt>true</tt> if any of the tasks passed errors back to the runner,
     * otherwise <tt>false</tt>.
     */
    boolean hasErrors();

    /**
     * Returns an iterator over Strings representing the errors returned by any tasks
     * that have been run. The underlying collection is not modifiable.
     */
    Iterator getErrorsIterator();

    /**
     * Clear any errors returned by previous tasks.
     */
    void resetErrors();
}
