package com.atlassian.paddle.task;

import javax.naming.directory.DirContext;
import java.util.Collection;

/**
 * A task to be run on an LDAP server. The method {@link #withConnection(DirContext, Collection, long)} should
 * be overridden to do something with a given LDAP context, and optionally return a collection of errors.
 */
public interface Task
{
    /**
     * Implementations implement this method to do something with an LDAP
     * connection provided by a container.
     *
     * @param context LDAP connection provided by the container
     * @param errors add Strings to this collection to pass errors back to the container
     * @param countLimit maximum number of results to return
     */
    void withConnection(DirContext context, Collection errors, long countLimit);
}
