package com.atlassian.paddle.task;

import com.atlassian.paddle.OutputReceiver;
import com.atlassian.paddle.search.*;
import com.atlassian.paddle.search.properties.GroupSearchProperties;
import com.atlassian.paddle.search.properties.MembershipSearchProperties;
import com.atlassian.paddle.search.properties.UserSearchProperties;
import org.apache.log4j.Logger;

import javax.naming.directory.DirContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class ListUsersTask implements Task
{
    private final Logger logger = Logger.getLogger(getClass());
    private final UserSearchProperties userSearchProperties;
    private final MembershipSearchProperties membershipSearchProperties;
    private final GroupSearchProperties groupSearchProperties;
    private final OutputReceiver outputReceiver;

    public ListUsersTask(UserSearchProperties userSearchProperties,
        MembershipSearchProperties membershipSearchProperties, GroupSearchProperties groupSearchProperties, OutputReceiver outputReceiver)
    {
        this.userSearchProperties = userSearchProperties;
        this.membershipSearchProperties = membershipSearchProperties;
        this.groupSearchProperties = groupSearchProperties;
        this.outputReceiver = outputReceiver;
    }

    public void withConnection(DirContext context, Collection errors, long countLimit)
    {
        Searcher searcher = new DefaultSearcher(context, countLimit, outputReceiver);

        Collection userDns = doSearch(searcher, errors, new UsersSearch(userSearchProperties));

        for (Iterator userIterator = userDns.iterator(); userIterator.hasNext();)
        {
            String userDn = (String) userIterator.next();
            outputReceiver.provideInfoFeedback("User: " + userDn);

            GroupsForUserSearch groupsSearch = new GroupsForUserSearch(userDn, groupSearchProperties,
                membershipSearchProperties);
            Collection groups = doSearch(searcher, errors, groupsSearch);
            if (groups.isEmpty())
            {
                outputReceiver.provideInfoFeedback("\tDoes not belong to any LDAP groups.\n");
                continue;
            }

            outputReceiver.provideInfoFeedback("Member of:");
            for (Iterator groupsIterator = groups.iterator(); groupsIterator.hasNext();)
            {
                String groupDn = (String) groupsIterator.next();
                outputReceiver.provideInfoFeedback("\t" + groupDn);
            }
            outputReceiver.provideInfoFeedback("");
        }
    }

    private Collection doSearch(Searcher searcher, Collection errors, Search search)
    {
        try
        {
            return searcher.search(search, new DnResultConverter());
        }
        catch (SearchException e)
        {
            logger.debug(e, e);
            errors.add(e.getMessage());
            return Collections.EMPTY_SET;
        }
    }
}
