package com.atlassian.paddle.task;

import com.atlassian.paddle.Group;
import com.atlassian.paddle.OutputReceiver;
import com.atlassian.paddle.search.*;
import com.atlassian.paddle.search.properties.GroupSearchProperties;
import com.atlassian.paddle.search.properties.MembershipSearchProperties;

import javax.naming.directory.DirContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class ListGroupsTask implements Task
{
    private final GroupSearchProperties groupSearchProperties;
    private final MembershipSearchProperties membershipSearchProperties;
    private final OutputReceiver outputReceiver;

    public ListGroupsTask(GroupSearchProperties groupSearchProperties,
        MembershipSearchProperties membershipSearchProperties, OutputReceiver outputReceiver)
    {
        this.groupSearchProperties = groupSearchProperties;
        this.membershipSearchProperties = membershipSearchProperties;
        this.outputReceiver = outputReceiver;
    }

    public void withConnection(DirContext context, Collection errors, long countLimit)
    {
        Searcher searcher = new DefaultSearcher(context, countLimit, outputReceiver);

        GroupsSearch search = new GroupsSearch(groupSearchProperties, membershipSearchProperties);
        Collection groups = doSearch(searcher, errors, search, countLimit);
        for (Iterator groupsIterator = groups.iterator(); groupsIterator.hasNext();)
        {
            Group group = (Group) groupsIterator.next();
            outputReceiver.provideInfoFeedback(String.valueOf(group));
        }
    }

    private Collection doSearch(Searcher searcher, Collection errors, Search search, long memberCountLimit)
    {
        GroupResultConverter converter = new GroupResultConverter(membershipSearchProperties.getMembershipAttribute(),
            memberCountLimit);
        try
        {
            return searcher.search(search, converter);
        }
        catch (SearchException e)
        {
            outputReceiver.provideErrorFeedback(e.getMessage(), e);
            errors.add(e.getMessage());
            return Collections.EMPTY_LIST;
        }
    }
}
