package com.atlassian.paddle.task;

import com.atlassian.paddle.connection.ConnectionFactory;
import com.atlassian.paddle.connection.ConnectionException;

import javax.naming.directory.DirContext;
import javax.naming.NamingException;

import org.apache.log4j.Logger;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Iterator;
import java.util.Collections;

/**
 * Runs {@link Task}s using the provided {@link ConnectionFactory},
 * taking care to close any connections it opens.
 */
public class DefaultTaskRunner implements TaskRunner
{
    private final Logger logger = Logger.getLogger(getClass());
    private final ConnectionFactory connectionFactory;
    private final Collection errors = new LinkedList();

    public DefaultTaskRunner(ConnectionFactory connectionFactory)
    {
        this.connectionFactory = connectionFactory;
    }

    public void runTask(Task task, long countLimit) throws ConnectionException
    {
        DirContext context = connectionFactory.createConnection();
        try
        {
            task.withConnection(context, errors, countLimit);
        }
        finally
        {
            try
            {
                context.close();
            }
            catch (NamingException e)
            {
                logger.warn("Error closing LDAP connection, possible resource leak", e);
            }
        }
    }

    public boolean hasErrors()
    {
        return !errors.isEmpty();
    }

    public Iterator getErrorsIterator()
    {
        return Collections.unmodifiableCollection(errors).iterator();
    }

    public void resetErrors()
    {
        errors.clear();
    }
}
