package com.atlassian.paddle.search.properties;

public interface MembershipSearchProperties
{
    /**
     * Returns <tt>true</tt> if the attribute which indicates membership is on the group, or <tt>false</tt> if the
     * attribute is found on the user.
     *
     * @see #getMembershipAttribute()
     */
    boolean isMembershipAttributeOnGroup();

    /**
     * Returns the name of the attribute which indicates group membership.
     * <p/>
     * This attribute might be found on either the user or group record, depending on the return value of {@link
     * #isMembershipAttributeOnGroup()}.
     * <p/>
     * The attribute value in the repository may be either a qualified DN or common name, depending on the value of
     * {@link #isMembershipValueQualifiedDn()}.
     */
    String getMembershipAttribute();

    /**
     * Returns <tt>true</tt> if the value of the membership attribute in the repository is a full-qualified DN, or
     * <tt>false</tt> if the attribute value is just a common name.
     * <p/>
     * If the attribute value is just a common name, and the membership attribute is on the user, the DN of the group
     * must be able to be formed from this value by prepending the group name attribute ({@link
     * GroupSearchProperties#getGroupNameAttribute()} and appending a comma followed by the group search base DN ({@link
     * GroupSearchProperties#getBaseDn()}.
     * <p/>
     * The same process must apply to a determine a user's DN from the  common name if the membership attribute is on
     * the group, except with {@link UserSearchProperties#getUserNameAttribute()} and {@link
     * UserSearchProperties#getBaseDn()} instead.
     */
    boolean isMembershipValueQualifiedDn();
}
