package com.atlassian.paddle.search.properties;

public class DefaultUserSearchProperties implements UserSearchProperties
{
    private final String baseDn;
    private final String filter;
    private final boolean subTreeSearch;
    private final String userNameAttribute;
    private final String firstNameAttribute;
    private final String lastNameAttribute;
    private final String emailAttribute;

    public DefaultUserSearchProperties(String baseDn, String filter, boolean subTreeSearch, String userNameAttribute,
        String firstNameAttribute, String lastNameAttribute, String emailAttribute)
    {
        this.baseDn = baseDn;
        this.filter = filter;
        this.subTreeSearch = subTreeSearch;
        this.userNameAttribute = userNameAttribute;
        this.firstNameAttribute = firstNameAttribute;
        this.lastNameAttribute = lastNameAttribute;
        this.emailAttribute = emailAttribute;
    }

    public String getBaseDn()
    {
        return baseDn;
    }

    public String getFilter()
    {
        return filter;
    }

    public boolean isSubTreeSearch()
    {
        return subTreeSearch;
    }

    public String getUserNameAttribute()
    {
        return userNameAttribute;
    }

    public String getFirstNameAttribute()
    {
        return firstNameAttribute;
    }

    public String getLastNameAttribute()
    {
        return lastNameAttribute;
    }

    public String getEmailAttribute()
    {
        return emailAttribute;
    }
}
