package com.atlassian.paddle.search.properties;

public class DefaultMembershipSearchProperties implements MembershipSearchProperties
{
    private final String membershipAttribute;
    private final boolean membershipAttributeOnGroup;
    private final boolean membershipValueQualifiedDn;

    public DefaultMembershipSearchProperties(String membershipAttribute, boolean membershipAttributeOnGroup,
        boolean membershipValueQualifiedDn)
    {
        this.membershipAttribute = membershipAttribute;
        this.membershipAttributeOnGroup = membershipAttributeOnGroup;
        this.membershipValueQualifiedDn = membershipValueQualifiedDn;
    }

    public boolean isMembershipAttributeOnGroup()
    {
        return membershipAttributeOnGroup;
    }

    public String getMembershipAttribute()
    {
        return membershipAttribute;
    }

    public boolean isMembershipValueQualifiedDn()
    {
        return membershipValueQualifiedDn;
    }
}
