package com.atlassian.paddle.search.properties;

public class DefaultGroupSearchProperties implements GroupSearchProperties
{
    private final String baseDn;
    private final String filter;
    private final boolean subTreeSearch;
    private final String groupNameAttribute;

    public DefaultGroupSearchProperties(String baseDn, String filter, boolean subTreeSearch,
        String groupNameAttribute)
    {
        this.baseDn = baseDn;
        this.filter = filter;
        this.subTreeSearch = subTreeSearch;
        this.groupNameAttribute = groupNameAttribute;
    }

    public String getBaseDn()
    {
        return baseDn;
    }

    public String getFilter()
    {
        return filter;
    }

    public boolean isSubTreeSearch()
    {
        return subTreeSearch;
    }

    public String getGroupNameAttribute()
    {
        return groupNameAttribute;
    }
}
