package com.atlassian.paddle.search;

import com.atlassian.paddle.search.properties.UserSearchProperties;

import javax.naming.directory.SearchControls;

public class UsersSearch extends AbstractSearch
{
    private final UserSearchProperties properties;

    public UsersSearch(UserSearchProperties properties)
    {
        this.properties = properties;
    }

    public String getBaseDn()
    {
        return properties.getBaseDn();
    }

    public String getFilter()
    {
        return properties.getFilter();
    }

    protected String[] getAttributesToReturn()
    {
        return new String[]{
            properties.getUserNameAttribute(),
            properties.getFirstNameAttribute(),
            properties.getLastNameAttribute(),
            properties.getEmailAttribute()};
    }

    public SearchControls getSearchControls()
    {
        SearchControls result = super.getSearchControls();

        if (properties.isSubTreeSearch())
        {
            result.setSearchScope(SearchControls.SUBTREE_SCOPE);
        }
        else
        {
            result.setSearchScope(SearchControls.ONELEVEL_SCOPE);
        }
        return result;
    }
}
