package com.atlassian.paddle.search;

import java.util.Collection;

/**
 * Searches an LDAP search with the given parameters.
 */
public interface Searcher
{
    /**
     * Returns an collection of the results of the search. The contents of the collection
     * depends on the implementation.
     * <p/>
     * The client is responsible for closing the enumeration, typically in a finally block.
     *
     * @param search the search to perform
     * @param resultConverter object to convert the LDAP search results enumeration into a Collection
     * @return an iterator of search results
     * @throws SearchException if the search fails
     */
    Collection search(Search search, ResultConverter resultConverter) throws SearchException;
}
