package com.atlassian.paddle.search;

import javax.naming.directory.SearchControls;

/**
 * Parameters for performing an LDAP search: a base DN, a filter, and parameters.
 */
public interface Search
{
    /**
     * @return base DN for search
     */
    public String getBaseDn();

    /**
     * @return the search filter
     */
    public String getFilter();

    /**
     * @return parameters for the search, including attributes to return and scope of search.
     */
    public SearchControls getSearchControls();
}
