package com.atlassian.paddle.search;

import com.atlassian.paddle.search.properties.GroupSearchProperties;
import com.atlassian.paddle.search.properties.MembershipSearchProperties;

import javax.naming.directory.SearchControls;

public class GroupsSearch extends AbstractSearch
{
    private final GroupSearchProperties groupSearchProperties;
    private final MembershipSearchProperties membershipSearchProperties;

    public GroupsSearch(GroupSearchProperties groupSearchProperties, MembershipSearchProperties membershipSearchProperties)
    {
        this.groupSearchProperties = groupSearchProperties;
        this.membershipSearchProperties = membershipSearchProperties;
    }

    public String getBaseDn()
    {
        return groupSearchProperties.getBaseDn();
    }

    public String getFilter()
    {
        return groupSearchProperties.getFilter();
    }

    protected String[] getAttributesToReturn()
    {
        return new String[]{
            groupSearchProperties.getGroupNameAttribute(),
            membershipSearchProperties.getMembershipAttribute() };
    }

    public SearchControls getSearchControls()
    {
        SearchControls result = super.getSearchControls();

        if (groupSearchProperties.isSubTreeSearch())
        {
            result.setSearchScope(SearchControls.SUBTREE_SCOPE);
        }
        else
        {
            result.setSearchScope(SearchControls.ONELEVEL_SCOPE);
        }
        return result;
    }
}
