package com.atlassian.paddle.search;

import com.atlassian.paddle.filter.LiteralFilter;
import com.atlassian.paddle.search.properties.MembershipSearchProperties;
import com.atlassian.paddle.search.properties.GroupSearchProperties;
import net.sf.ldaptemplate.support.filter.AndFilter;
import net.sf.ldaptemplate.support.filter.EqualsFilter;

public class GroupsForUserSearch extends AbstractSearch
{
    private final String userDn;
    private final MembershipSearchProperties membershipSearchProperties;
    private final GroupSearchProperties groupSearchProperties;

    public GroupsForUserSearch(String userDn, GroupSearchProperties groupSearchProperties,
        MembershipSearchProperties membershipSearchProperties)
    {
        this.userDn = userDn;
        this.membershipSearchProperties = membershipSearchProperties;
        this.groupSearchProperties = groupSearchProperties;
    }

    public String getBaseDn()
    {
        return groupSearchProperties.getBaseDn();
    }

    public String getFilter()
    {
        AndFilter andFilter = new AndFilter();
        andFilter.and(new LiteralFilter(groupSearchProperties.getFilter()));
        andFilter.and(new EqualsFilter(membershipSearchProperties.getMembershipAttribute(), userDn));
        return andFilter.toString();
    }

    protected String[] getAttributesToReturn()
    {
        return new String[] {
            groupSearchProperties.getGroupNameAttribute(),
            membershipSearchProperties.getMembershipAttribute(),
        };
    }
}
