package com.atlassian.paddle.search;

import com.atlassian.paddle.Group;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import javax.naming.directory.Attribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Collections;

/**
 * Converts LDAP search results into a collection of {@link Group}s.
 */
public class GroupResultConverter implements ResultConverter
{
    private String membershipAttribute;
    private final long memberCountLimit;

    public GroupResultConverter(String membershipAttribute, long memberCountLimit)
    {
        this.membershipAttribute = membershipAttribute;
        this.memberCountLimit = memberCountLimit;
    }

    public Collection convert(Search search, NamingEnumeration results)
    {
        Collection result = new HashSet();
        while (results.hasMoreElements())
        {
            SearchResult searchResult = (SearchResult) results.nextElement();
            String groupDn = searchResult.getName() + "," + search.getBaseDn();

            Collection members = getAttributeValues(searchResult, membershipAttribute, memberCountLimit);
            result.add(new Group(groupDn, members));
        }
        return result;
    }

    private Collection getAttributeValues(SearchResult searchResult, String attributeName, long countLimit)
    {
        Collection members = new LinkedList();
        Attribute ldapMembershipAttribute = searchResult.getAttributes().get(attributeName);
        if (ldapMembershipAttribute == null)
        {
            return Collections.EMPTY_LIST;
        }

        NamingEnumeration attributeValues;
        try
        {
            attributeValues = ldapMembershipAttribute.getAll();
        }
        catch (NamingException e)
        {
            return Collections.EMPTY_LIST;
        }

        long j = 0;
        while (attributeValues.hasMoreElements() && j < countLimit)
        {
            String member = (String) attributeValues.nextElement();
            members.add(member);
            j++;
        }
        return members;
    }
}
