package com.atlassian.paddle.search;

import javax.naming.NamingEnumeration;
import javax.naming.directory.SearchResult;
import java.util.Collection;
import java.util.HashSet;

/**
 * Returns a collection of the DNs of each result.
 */
public class DnResultConverter implements ResultConverter
{
    public Collection convert(Search search, NamingEnumeration enumeration)
    {
        Collection result = new HashSet();
        while (enumeration.hasMoreElements())
        {
            SearchResult searchResult = (SearchResult) enumeration.nextElement();
            result.add(searchResult.getName() + "," + search.getBaseDn());
        }
        return result;
    }
}
