package com.atlassian.paddle.search;

import org.apache.log4j.Logger;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import java.util.Collection;

import com.atlassian.paddle.OutputReceiver;

public class DefaultSearcher implements Searcher
{
    private final Logger logger = Logger.getLogger(getClass());
    private final DirContext context;
    private final long countLimit;
    private OutputReceiver outputReceiver;

    public DefaultSearcher(DirContext context, long countLimit, OutputReceiver outputReceiver)
    {
        this.context = context;
        this.countLimit = countLimit;
        this.outputReceiver = outputReceiver;
    }

    public Collection search(Search search, ResultConverter resultConverter) throws SearchException
    {
        String baseDn = search.getBaseDn();
        String filter = search.getFilter();
        SearchControls controls = search.getSearchControls();
        outputReceiver.provideDebugFeedback("Limiting maximum number of results to " + countLimit + " for " + search);
        controls.setCountLimit(countLimit);

        NamingEnumeration searchResults = null;
        try
        {
            outputReceiver.provideDebugFeedback("Starting LDAP search for " + search);
            long start = System.currentTimeMillis();
            searchResults = context.search(baseDn, filter, controls);
            long tookMillis = System.currentTimeMillis() - start;
            outputReceiver.provideDebugFeedback("Completed search in " + tookMillis + " ms for " + search);
            Collection results = resultConverter.convert(search, searchResults);
            outputReceiver.provideDebugFeedback("Found " + results.size() + " results for " + search);
            return results;
        }
        catch (NamingException e)
        {
            throw new SearchException("Error performing LDAP search " + search + ": " + e.getMessage(), e);
        }
        finally
        {
            try
            {
                if (searchResults != null) searchResults.close();
            }
            catch (NamingException e)
            {
                logger.warn("Could not close search results, possible resource leak", e);
            }
        }
    }
}
