package com.atlassian.paddle.search;

import javax.naming.directory.SearchControls;

/**
 * Provides default search controls and a simple toString().
 */
public abstract class AbstractSearch implements Search
{
    /**
     * Array of attributes names which will be retrieved for search results.
     */
    abstract protected String[] getAttributesToReturn();

    public SearchControls getSearchControls()
    {
        SearchControls result = new SearchControls();
        result.setReturningAttributes(getAttributesToReturn());
        result.setSearchScope(SearchControls.SUBTREE_SCOPE);
        result.setCountLimit(0); // default to retrieving all results
        return result;
    }

    public String toString()
    {
        return "filter '" + getFilter() + "', base DN '" + getBaseDn() + "'";
    }
}
