package com.atlassian.paddle.connection;

public class DefaultConnectionProperties implements ConnectionProperties
{
    public static final String AUTHENTICATION_NONE = "none";
    public static final String AUTHENTICATION_SIMPLE = "simple";
    public static final String AUTHENTICATION_PROTOCOL_PLAIN = "plain";
    private static final int DEFAULT_BATCH_SIZE = 10;

    private final String host;
    private final String port;
    private final String securityAuthentication;
    private final String securityProtocol;
    private final String username;
    private final String password;
    private final int batchSize = DEFAULT_BATCH_SIZE;

    public DefaultConnectionProperties(String host, String port, String securityAuthentication,
        String securityProtocol, String username, String password)
    {
        this.host = host;
        this.port = port;
        this.securityAuthentication = securityAuthentication;
        this.securityProtocol = securityProtocol;
        this.username = username;
        this.password = password;
    }

    public String getProviderUrl()
    {
        return "ldap://" + host + ":" + port;
    }

    public String getSecurityProtocol()
    {
        return securityProtocol;
    }

    public String getBatchSize()
    {
        return String.valueOf(batchSize);
    }

    public boolean isAnonymousAuthentication()
    {
        return securityAuthentication != null && securityAuthentication.equals(AUTHENTICATION_NONE);
    }

    public String getUsername()
    {
        return username;
    }

    public String getPassword()
    {
        return password;
    }

    public String getSecurityAuthentication()
    {
        return securityAuthentication;
    }
}
