package com.atlassian.paddle.connection;

import javax.naming.directory.DirContext;

public interface ConnectionFactory
{
    /**
     * Opens a new LDAP connection. Client is responsible for closing the
     * connection in a finally block.
     *
     * @return a new LDAP connection, configured in a factory-specific manner
     * @throws ConnectionException if there was a problem connecting to the LDAP server
     */
    DirContext createConnection() throws ConnectionException;
}
