package com.atlassian.paddle.configuration;

import com.atlassian.paddle.OutputReceiver;

public interface Configuration
{
    /**
     * Returns the value of the given attribute, converted to a String. Returns
     * <tt>null</tt> if the attribute does not exist.
     *
     * @param attributeName the name of the attribute to retrieve
     * @return the String value of the attribute, or <tt>null</tt> if it does not
     * exist
     */
    String getAttribute(String attributeName);

    /**
     * Returns the value of the given attribute, converted to a String. Returns
     * <tt>null</tt> if the attribute does not exist.
     * <p/>
     * If the attribute does not exist, a warning will be logged to the provided
     * logger noting this.
     *
     * @param attributeName the name of the attribute to retrieve
     * @param logger where a warning will be logged if the attribute is missing
     * @return the String value of the attribute, or <tt>null</tt> if it does not
     * exist
     */
    String getAttributeInfoIfMissing(String attributeName, OutputReceiver logger);
}
