package com.atlassian.paddle;

import org.apache.commons.lang.exception.ExceptionUtils;

/**
 * This OutputReceiver will provide feedback to the user by using a StringBuffer which all connectivity information
 * will be appended to.
 */
public class StringOutputReceiver implements OutputReceiver
{

    private StringBuffer buffer = new StringBuffer();

    private boolean debugOn = false;

    public void provideInfoFeedback(String info)
    {
        buffer.append(info).append("\n");
    }

    public void provideErrorFeedback(String error, Exception e)
    {
        buffer.append(error).append("\n");
        buffer.append(ExceptionUtils.getFullStackTrace(e)).append("\n");
    }

    public void provideDebugFeedback(String debug)
    {
        if (debugOn)
        {
            buffer.append(debug).append("\n");
        }
    }

    public void setDebuggingFeedback(boolean on)
    {
        debugOn = on;
    }

    public String getOutput(){
        return buffer.toString();
    }
}
