package com.atlassian.paddle;

import org.apache.log4j.Logger;
import org.apache.log4j.Level;

public class LoggerOutputReceiver implements OutputReceiver
{
    private final Logger logger;

    public LoggerOutputReceiver(Logger logger)
    {
        this.logger = logger;
    }

    public void provideInfoFeedback(String info)
    {
        logger.info(info);
    }

    public void provideErrorFeedback(String error, Exception e)
    {
        logger.error(error, e);
    }

    public void provideDebugFeedback(String debug)
    {
        logger.debug(debug);
    }

    public void setDebuggingFeedback(boolean on)
    {
        if(on){
        logger.setLevel(Level.DEBUG);
        }
    }
}
