package com.atlassian.paddle;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Collections;
import java.util.Iterator;

public class Group
{
    private final String dn;
    private final Collection memberDns;

    public Group(String dn, Collection memberDns)
    {
        this.dn = dn;
        this.memberDns = new LinkedList(memberDns);
    }

    /**
     * @return DN of the group as a String
     */
    public String getDn()
    {
        return dn;
    }

    /**
     * @return Collection of String DNs of members of the group
     */
    public Collection getMemberDns()
    {
        return Collections.unmodifiableCollection(memberDns);
    }

    public String toString()
    {
        StringBuffer result = new StringBuffer();
        result.append("Group: ").append(dn).append("\n");
        result.append("Members:\n");
        for (Iterator iterator = memberDns.iterator(); iterator.hasNext();)
        {
            String dn = (String) iterator.next();
            result.append("\t").append(dn).append("\n");
        }
        if (memberDns.isEmpty())
        {
            result.append("\tNo members in this group.\n");
        }
        return result.toString(); 
    }
}
