package com.atlassian.paddle;

import java.util.*;

/**
 * Parsers command-line arguments to Paddle. Any dashes at the start of a command-line argument
 * are discarded, and empty arguments are ignored.
 */
public class Arguments
{
    private final Set arguments = new HashSet();
    private final Map argumentValues = new HashMap();

    public Arguments(String[] args)
    {
        for (int i = 0; i < args.length; i++)
        {
            String arg = args[i].replaceFirst("^-+", "").trim();
            if (arg.length() == 0) continue;
            if (arg.indexOf("=") >= 0)
            {
                String[] parts = arg.split("=", 2);
                arg = parts[0];
                String value = parts[1];
                argumentValues.put(arg, value);
            }
            arguments.add(arg);
        }
    }

    /**
     * Return <tt>true</tt> if the named argument exists, otherwise false.
     */
    public boolean contains(String argument)
    {
        return arguments.contains(argument);
    }

    /**
     * Returns the number of arguments identified.
     */
    public int count()
    {
        return arguments.size();
    }

    public String getValue(String argument)
    {
        return (String) argumentValues.get(argument);
    }
}
