/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.MfDcState;
import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.graphics.wmf.records.MfCmd;
import com.benryan.graphics.wmf.records.RecordCreationException;

public class MfCmdSetTextCharExtra
extends MfCmd {
    private static final int RECORD_SIZE = 1;
    private static final int POS_TEXT_CHAR_EXTRA = 0;
    private int textCharExtra;

    @Override
    public void replay(WmfFile file) {
        MfDcState state = file.getCurrentState();
        state.setTextCharExtra(this.textCharExtra);
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdSetTextCharExtra();
    }

    @Override
    public void setRecord(MfRecord record) {
        int id = record.getParam(0);
        this.setTextCharExtra(id);
    }

    @Override
    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(1);
        record.setParam(0, this.getTextCharExtra());
        return record;
    }

    @Override
    public int getFunction() {
        return 264;
    }

    public int getTextCharExtra() {
        return this.textCharExtra;
    }

    public void setTextCharExtra(int id) {
        this.textCharExtra = id;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[SET_TEXT_CHAR_EXTRA] textCharExtra=");
        b.append(this.getTextCharExtra());
        return b.toString();
    }

    @Override
    protected void scaleXChanged() {
    }

    @Override
    protected void scaleYChanged() {
    }
}

