/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.MfDcState;
import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.graphics.wmf.records.MfCmd;
import com.benryan.graphics.wmf.records.RecordCreationException;

public class MfCmdSetPolyFillMode
extends MfCmd {
    private static final int RECORD_SIZE = 1;
    private static final int POS_POLYFILLMODE = 0;
    public static final int ALTERNATE = 1;
    public static final int WINDING = 2;
    private int fillmode;

    @Override
    public void replay(WmfFile file) {
        MfDcState state = file.getCurrentState();
        state.setPolyFillMode(this.fillmode);
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdSetPolyFillMode();
    }

    @Override
    public void setRecord(MfRecord record) {
        int id = record.getParam(0);
        this.setFillMode(id);
    }

    @Override
    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(1);
        record.setParam(0, this.getFillMode());
        return record;
    }

    @Override
    public int getFunction() {
        return 262;
    }

    public int getFillMode() {
        return this.fillmode;
    }

    public void setFillMode(int id) {
        this.fillmode = id;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[SET_POLY_FILL_MODE] fillmode=");
        b.append(this.getFillMode());
        return b.toString();
    }

    @Override
    protected void scaleXChanged() {
    }

    @Override
    protected void scaleYChanged() {
    }
}

