/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.MfDcState;
import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.graphics.wmf.records.MfCmd;
import java.awt.Point;

public class MfCmdOffsetWindowOrg
extends MfCmd {
    private static final int RECORD_SIZE = 2;
    private static final int POS_X = 1;
    private static final int POS_Y = 0;
    private int x;
    private int y;
    private int scaled_x;
    private int scaled_y;

    @Override
    public void replay(WmfFile file) {
        MfDcState state = file.getCurrentState();
        Point p = this.getScaledDestination();
        state.setWindowOrg(state.getWindowOrgX() + p.x, state.getWindowOrgY() + p.y);
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdOffsetWindowOrg();
    }

    public Point getDestination() {
        return new Point(this.x, this.y);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[OFFSET_WINDOWORG] destination=");
        b.append(this.getDestination());
        return b.toString();
    }

    public void setDestination(int x, int y) {
        this.x = x;
        this.y = y;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setDestination(Point p) {
        this.setDestination(p.x, p.y);
    }

    @Override
    public MfRecord getRecord() {
        Point dest = this.getDestination();
        MfRecord record = new MfRecord(2);
        record.setParam(0, dest.y);
        record.setParam(1, dest.x);
        return record;
    }

    @Override
    public int getFunction() {
        return 527;
    }

    @Override
    public void setRecord(MfRecord record) {
        int y = record.getParam(0);
        int x = record.getParam(1);
        this.setDestination(x, y);
    }

    public Point getScaledDestination() {
        return new Point(this.scaled_x, this.scaled_y);
    }

    @Override
    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
    }

    @Override
    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
    }
}

