/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.MfLogRegion;
import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.graphics.wmf.records.MfCmd;
import java.awt.Color;
import java.awt.Graphics2D;

public class MfCmdInvertRegion
extends MfCmd {
    private int region;
    private static final int RECORD_SIZE = 1;
    private static final int POS_REGION = 0;

    @Override
    public void replay(WmfFile file) {
        Graphics2D g2 = (Graphics2D)file.getGraphics2D().create();
        g2.setXORMode(Color.white);
        MfLogRegion reg = file.getRegionObject(this.getRegion());
        g2.fill(reg.getBounds());
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdInvertRegion();
    }

    @Override
    public void setRecord(MfRecord record) {
        this.region = record.getParam(0);
    }

    @Override
    public MfRecord getRecord() {
        MfRecord record = new MfRecord(1);
        record.setParam(0, this.getRegion());
        return record;
    }

    public void setRegion(int region) {
        this.region = region;
    }

    public int getRegion() {
        return this.region;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[INVERT_REGION] region=");
        b.append(this.getRegion());
        return b.toString();
    }

    @Override
    public int getFunction() {
        return 298;
    }

    @Override
    protected void scaleXChanged() {
    }

    @Override
    protected void scaleYChanged() {
    }
}

