/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.GDIColor;
import com.benryan.graphics.wmf.MfLogPalette;
import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.graphics.wmf.records.MfCmd;
import com.benryan.graphics.wmf.records.RecordCreationException;
import java.awt.Color;

public class MfCmdCreatePalette
extends MfCmd {
    private static final int POS_HPALETTE = 0;
    private static final int POS_CENTRIES = 1;
    private static final int POS_START_ENTRIES = 2;
    private int hPalette;
    private Color[] colors;

    @Override
    public int getFunction() {
        return 247;
    }

    public int getEntriesCount() {
        if (this.colors == null) {
            return 0;
        }
        return this.colors.length;
    }

    @Override
    public MfRecord getRecord() throws RecordCreationException {
        int cEntries = this.getEntriesCount();
        if (cEntries == 0) {
            throw new RecordCreationException("Empty CreatePaletteRecord is not valid");
        }
        MfRecord record = new MfRecord(2 + cEntries * 2);
        record.setParam(0, this.getHPalette());
        record.setParam(1, cEntries);
        Color[] colors = new Color[cEntries];
        for (int i = 0; i < cEntries; ++i) {
            Color c = colors[i];
            record.setLongParam(i * 2 + 2, GDIColor.translateColor(c));
        }
        return record;
    }

    @Override
    public void setRecord(MfRecord record) {
        int hPalette = record.getParam(0);
        this.setHPalette(hPalette);
        int cEntries = record.getParam(1);
        Color[] colors = new Color[cEntries];
        for (int i = 0; i < cEntries; ++i) {
            int cr = record.getLongParam(i * 2 + 2);
            GDIColor color = new GDIColor(cr);
            colors[i] = color;
        }
        this.setEntries(colors);
    }

    @Override
    public void replay(WmfFile file) {
        MfLogPalette pal = new MfLogPalette();
        file.getCurrentState().setLogPalette(pal);
        file.storeObject(pal);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[CREATE_PALETTE] ");
        b.append(" no internals known ");
        return b.toString();
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdCreatePalette();
    }

    @Override
    protected void scaleXChanged() {
    }

    @Override
    protected void scaleYChanged() {
    }

    public int getHPalette() {
        return this.hPalette;
    }

    public void setHPalette(int hPalette) {
        this.hPalette = hPalette;
    }

    public Color[] getEntries() {
        return this.colors;
    }

    public void setEntries(Color[] colors) {
        this.colors = colors;
    }
}

