/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.GDIColor;
import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.graphics.wmf.records.MfCmd;
import com.benryan.graphics.wmf.records.RecordCreationException;
import java.awt.Color;

public class MfCmdAnimatePalette
extends MfCmd {
    private static final int POS_START_ANIMATE_COLOR = 0;
    private static final int POS_CENTRIES = 1;
    private static final int POS_START_ENTRIES = 2;
    private int posStartAnimate;
    private Color[] colors;

    public int getEntriesCount() {
        if (this.colors == null) {
            return 0;
        }
        return this.colors.length;
    }

    @Override
    public MfRecord getRecord() throws RecordCreationException {
        int cEntries = this.getEntriesCount();
        if (cEntries == 0) {
            throw new RecordCreationException("Empty AnimatePaletteRecord is not valid");
        }
        MfRecord record = new MfRecord(2 + cEntries * 2);
        record.setParam(0, this.getPosStartAnimate());
        record.setParam(1, cEntries);
        Color[] colors = new Color[cEntries];
        for (int i = 0; i < cEntries; ++i) {
            Color c = colors[i];
            record.setLongParam(i * 2 + 2, GDIColor.translateColor(c));
        }
        return record;
    }

    @Override
    public void setRecord(MfRecord record) {
        int hPalette = record.getParam(0);
        this.setPosStartAnimate(hPalette);
        int cEntries = record.getParam(1);
        Color[] colors = new Color[cEntries];
        for (int i = 0; i < cEntries; ++i) {
            int cr = record.getLongParam(i * 2 + 2);
            GDIColor color = new GDIColor(cr);
            colors[i] = color;
        }
        this.setEntries(colors);
    }

    @Override
    public int getFunction() {
        return 1078;
    }

    @Override
    public void replay(WmfFile file) {
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[ANIMATE_PALETTE] posStartAnimate=");
        b.append(this.getPosStartAnimate());
        b.append(" entriesCount=");
        b.append(this.getEntriesCount());
        return b.toString();
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdAnimatePalette();
    }

    public int getPosStartAnimate() {
        return this.posStartAnimate;
    }

    public void setPosStartAnimate(int hPalette) {
        if (this.posStartAnimate < 0) {
            throw new IndexOutOfBoundsException("Palette indices must be positive.");
        }
        this.posStartAnimate = hPalette;
    }

    public Color[] getEntries() {
        return this.colors;
    }

    public void setEntries(Color[] colors) {
        this.colors = colors;
    }

    @Override
    protected void scaleXChanged() {
    }

    @Override
    protected void scaleYChanged() {
    }
}

