/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf;

import com.benryan.graphics.wmf.MfDcState;
import com.benryan.graphics.wmf.MfHeader;
import com.benryan.graphics.wmf.MfLogBrush;
import com.benryan.graphics.wmf.MfLogPen;
import com.benryan.graphics.wmf.MfLogRegion;
import com.benryan.graphics.wmf.MfPalette;
import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfObject;
import com.benryan.graphics.wmf.records.CommandFactory;
import com.benryan.graphics.wmf.records.MfCmd;
import com.benryan.graphics.wmf.records.MfCmdSetWindowExt;
import com.benryan.graphics.wmf.records.MfCmdSetWindowOrg;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;

public class WmfFile {
    public static final int QUALITY_NO = 0;
    public static final int QUALITY_MAYBE = 1;
    public static final int QUALITY_YES = 2;
    private static final int MAX_PICTURE_SIZE = WmfFile.getMaxPictureSize();
    private WmfObject[] objects;
    private Stack dcStack;
    private MfPalette palette;
    private InputStream in;
    private MfHeader header;
    private int fileSize;
    private int filePos;
    private ArrayList records;
    private Graphics2D graphics;
    private int logicalHeight;
    private int logicalWidth;
    private int deviceHeight;
    private int deviceWidth;
    private int orgX;
    private int orgY;
    private double aspectRatio;

    private static int getMaxPictureSize() {
        return 1200;
    }

    public WmfFile(URL input) throws IOException {
        this(input, -1, -1);
    }

    public WmfFile(String input) throws IOException {
        this(input, -1, -1);
    }

    public WmfFile(URL input, int imageX, int imageY) throws IOException {
        this(new BufferedInputStream(input.openStream()), imageX, imageY);
    }

    public WmfFile(String inName, int imageX, int imageY) throws FileNotFoundException, IOException {
        this(new BufferedInputStream(new FileInputStream(inName)), imageX, imageY);
    }

    public WmfFile(InputStream in, int imageX, int imageY) throws FileNotFoundException, IOException {
        this.in = in;
        this.deviceHeight = imageY;
        this.deviceWidth = imageX;
        this.records = new ArrayList();
        this.dcStack = new Stack();
        this.palette = new MfPalette();
        this.readHeader();
        this.parseRecords();
        this.resetStates();
    }

    public Dimension getImageSize() {
        return new Dimension(Math.abs(this.logicalWidth), Math.abs(this.logicalHeight));
    }

    public void resetStates() {
        Arrays.fill(this.objects, null);
        this.dcStack.clear();
        this.dcStack.push(new MfDcState(this));
    }

    public MfPalette getPalette() {
        return this.palette;
    }

    public static int isMetafile(String inName, InputStream in) {
        return MfHeader.isMetafile(inName, in);
    }

    public MfHeader getHeader() {
        return this.header;
    }

    public Graphics2D getGraphics2D() {
        return this.graphics;
    }

    public void assertValid() {
        if (this.filePos < 0 || this.filePos > this.fileSize) {
            throw new IllegalStateException("WmfFile is not valid");
        }
    }

    public MfHeader readHeader() throws IOException {
        this.header = new MfHeader();
        this.header.read(this.in);
        if (this.header.isValid()) {
            this.fileSize = this.header.getFileSize();
            this.objects = new WmfObject[this.header.getObjectsSize()];
            this.filePos = this.header.getHeaderSize();
            return this.header;
        }
        throw new IOException("The given file is not a real metafile");
    }

    public MfRecord readNextRecord() throws IOException {
        if (this.filePos >= this.fileSize) {
            return null;
        }
        this.assertValid();
        MfRecord record = new MfRecord(this.in);
        this.filePos += record.getLength();
        return record;
    }

    protected void parseRecords() throws IOException {
        MfRecord mf;
        int maxWidth = 0;
        int maxHeight = 0;
        this.orgX = Integer.MAX_VALUE;
        this.orgY = Integer.MAX_VALUE;
        CommandFactory cmdFactory = CommandFactory.getInstance();
        while ((mf = this.readNextRecord()) != null) {
            MfCmd worg;
            MfCmd cmd = cmdFactory.getCommand(mf.getType());
            if (cmd == null) continue;
            cmd.setRecord(mf);
            if (cmd.getFunction() == 523) {
                worg = (MfCmdSetWindowOrg)cmd;
                Point p = ((MfCmdSetWindowOrg)worg).getTarget();
                this.orgX = Math.min(p.x, this.orgX);
                this.orgY = Math.min(p.y, this.orgY);
            } else if (cmd.getFunction() == 524) {
                worg = (MfCmdSetWindowExt)cmd;
                Dimension d = ((MfCmdSetWindowExt)worg).getDimension();
                this.logicalWidth = Math.abs(d.width) > this.logicalWidth ? d.width : this.logicalWidth;
                this.logicalHeight = Math.abs(d.height) > this.logicalHeight ? d.height : this.logicalHeight;
            }
            this.records.add(cmd);
        }
        this.in.close();
        this.in = null;
        if (maxHeight > 0) {
            this.aspectRatio = maxWidth / maxHeight;
        }
    }

    public static void main(String[] args) throws Exception {
        WmfFile wmf = new WmfFile("./head/pixie/res/a0.wmf", 800, 600);
        wmf.replay(true);
    }

    public MfDcState getCurrentState() {
        return (MfDcState)this.dcStack.peek();
    }

    public void saveDCState() {
        MfDcState currentState = this.getCurrentState();
        this.dcStack.push(new MfDcState(currentState));
    }

    public int getStateCount() {
        return this.dcStack.size();
    }

    public void restoreDCState(int stateCount) {
        if (!(stateCount > 0)) {
            throw new IllegalArgumentException();
        }
        this.dcStack.pop();
        this.getCurrentState().restoredState();
    }

    protected int findFreeSlot() {
        for (int slot = 0; slot < this.objects.length; ++slot) {
            if (this.objects[slot] != null) continue;
            return slot;
        }
        throw new IllegalStateException("No free slot");
    }

    public void storeObject(WmfObject o) {
        int idx = this.findFreeSlot();
        this.objects[idx] = o;
    }

    public void deleteObject(int slot) {
        if (slot < 0 || slot >= this.objects.length) {
            throw new IllegalArgumentException("Range violation");
        }
        this.objects[slot] = null;
    }

    public WmfObject getObject(int slot) {
        if (slot < 0 || slot >= this.objects.length) {
            throw new IllegalStateException("Range violation");
        }
        return this.objects[slot];
    }

    public MfLogBrush getBrushObject(int slot) {
        WmfObject obj = this.getObject(slot);
        if (obj.getType() == 2) {
            return (MfLogBrush)obj;
        }
        throw new IllegalStateException("Object " + slot + " was no brush");
    }

    public MfLogPen getPenObject(int slot) {
        WmfObject obj = this.getObject(slot);
        if (obj.getType() == 1) {
            return (MfLogPen)obj;
        }
        throw new IllegalStateException("Object " + slot + " was no pen");
    }

    public MfLogRegion getRegionObject(int slot) {
        WmfObject obj = this.getObject(slot);
        if (obj.getType() == 5) {
            return (MfLogRegion)obj;
        }
        throw new IllegalStateException("Object " + slot + " was no region");
    }

    public synchronized BufferedImage replay(boolean antiAlias) {
        return this.replay(Math.abs(this.deviceWidth), Math.abs(this.deviceHeight), antiAlias);
    }

    public synchronized BufferedImage replay(int imageX, int imageY, boolean antiAlias) {
        return this.replay(imageX, imageY, true, antiAlias);
    }

    public synchronized BufferedImage replay(int imageX, int imageY, boolean maintainAspect, boolean antiAlias) {
        if (maintainAspect) {
            double xScale = (double)imageX / (double)this.logicalWidth;
            double yScale = (double)imageY / (double)this.logicalHeight;
            double scale = Math.abs(1.0 - Math.abs(xScale)) < Math.abs(1.0 - Math.abs(yScale)) ? xScale : yScale;
            imageX = Math.abs((int)Math.round((double)this.logicalWidth * scale));
            imageY = Math.abs((int)Math.round((double)this.logicalHeight * scale));
            this.deviceWidth = imageX;
            this.deviceHeight = imageY;
        }
        BufferedImage image = new BufferedImage(imageX, imageY, 2);
        Graphics2D graphics = image.createGraphics();
        if (antiAlias) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics.setPaint(new Color(255, 255, 255, 0));
        graphics.fill(new Rectangle(0, 0, imageX, imageY));
        this.draw(graphics, new Rectangle2D.Float(0.0f, 0.0f, imageX, imageY));
        graphics.dispose();
        return image;
    }

    public synchronized void draw(Graphics2D graphics, Rectangle2D bounds) {
        this.graphics = graphics;
        for (int i = 0; i < this.records.size(); ++i) {
            try {
                MfCmd command = (MfCmd)this.records.get(i);
                command.setScale(this.orgX, this.orgY, (float)this.deviceWidth / (float)this.logicalWidth, (float)this.deviceHeight / (float)this.logicalHeight);
                command.replay(this);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.resetStates();
    }

    public String toString() {
        StringBuffer bo = new StringBuffer();
        bo.append("WmfFile={width=");
        bo.append(this.deviceWidth);
        bo.append(", height=");
        bo.append(this.deviceHeight);
        bo.append(", recordCount=");
        bo.append(this.records.size());
        bo.append(", records={\n");
        for (int i = 0; i < this.records.size(); ++i) {
            MfCmd cmd = (MfCmd)this.records.get(i);
            bo.append(i + "," + cmd.toString() + "\n");
        }
        bo.append("}\n");
        return bo.toString();
    }
}

