/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf;

import com.benryan.graphics.wmf.Buffer;
import com.benryan.graphics.wmf.MfType;
import java.io.IOException;
import java.io.InputStream;

public class MfRecord
extends Buffer {
    public static int RECORD_HEADER_SIZE = 6;
    private static int RECORD_TYPE_POS = 4;
    private MfType type = null;

    public MfRecord(int parcount) {
        super(parcount * 2 + RECORD_HEADER_SIZE);
    }

    public MfRecord(InputStream in) throws IOException {
        this.read(in);
    }

    protected void read(InputStream in) throws IOException {
        super.read(in, 0, RECORD_HEADER_SIZE);
        int remaining = this.getInt(0) * 2 - RECORD_HEADER_SIZE;
        if (remaining > 0) {
            super.read(in, RECORD_HEADER_SIZE, remaining);
        }
        this.type = MfType.get(this.getType());
    }

    public int getType() {
        return this.getShort(RECORD_TYPE_POS);
    }

    public void setType(int type) {
        this.setShort(RECORD_TYPE_POS, type);
    }

    public int getParam(int p) {
        return this.getShort(p * 2 + RECORD_HEADER_SIZE);
    }

    public void setParam(int p, int value) {
        this.setShort(p * 2 + RECORD_HEADER_SIZE, value);
    }

    public int getLongParam(int p) {
        return this.getInt(p * 2 + RECORD_HEADER_SIZE);
    }

    public void setLongParam(int p, int value) {
        this.setInt(p * 2 + RECORD_HEADER_SIZE, value);
    }

    public String getStringParam(int p, int len) {
        return this.getString(p * 2 + RECORD_HEADER_SIZE, len);
    }

    public void setStringParam(int p, String s) {
        this.setString(p * 2 + RECORD_HEADER_SIZE, s);
    }

    public String getName() {
        return this.type.getName();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.type);
        result.append(" ");
        result.append(this.getName());
        result.append(": ");
        StringBuffer str = new StringBuffer();
        int len = (this.getInt(0) - 3) * 2;
        for (int i = 0; i < len; ++i) {
            if (i % 16 == 0) {
                result.append("\n");
                str.append("\n");
            } else if (i % 8 == 0) {
                result.append(" ");
            }
            int by = this.getByte(i + RECORD_HEADER_SIZE);
            if (by < 16) {
                result.append("0");
            }
            result.append(Integer.toHexString(by));
            result.append(" ");
        }
        return result.toString();
    }

    public boolean doesMark() {
        return this.type.doesMark();
    }

    public boolean isMappingMode() {
        return this.type.isMappingMode();
    }
}

