/**
 * ========================================
 * Pixie : a free Java vector image library
 * ========================================
 *
 * Project Info:  http://www.jfree.org/jfreereport/pixie/
 * Project Lead:  Thomas Morgner;
 *
 * (C) Copyright 2000-2005, by Object Refinery Limited and Contributors.
 * (C) Copyright 2006, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * MfCmdUnknownCommand.java
 * ------------
 * (C) Copyright 2006, by Pentaho Corporation.
 *
 * Original Author:  Thomas Morgner;
 * Contributor(s):   -;
 *
 * $Id: MfCmdUnknownCommand.java,v 1.5 2006/04/17 15:03:24 taqua Exp $
 *
 * Changes
 * -------
 *
 *
 */

package com.benryan.graphics.wmf.records;

//import org.jfree.pixie.wmf.MfCmd;
//import org.jfree.pixie.wmf.MfCmdUnknownCommand;
//import org.jfree.pixie.wmf.RecordCreationException;

import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;

/**
 * This function is not in the validity list of Microsofts WindowsMetafile Records.
 */
public class MfCmdUnknownCommand extends MfCmd
{
  private int function;

  public MfCmdUnknownCommand ()
  {
  }

  public void replay (final WmfFile file)
  {
  }

  public MfCmd getInstance ()
  {
    return new MfCmdUnknownCommand();
  }

  public void setRecord (final MfRecord record)
  {
  }

  /**
   * Creates a new record based on the data stored in the MfCommand.
   *
   * @return the created record.
   */
  public MfRecord getRecord ()
          throws RecordCreationException
  {
    throw new RecordCreationException("The {Unknown Command} is not writeable");
  }

  public String toString ()
  {
    final StringBuffer b = new StringBuffer();
    b.append("[UNKNOWN COMMAND] " + Integer.toHexString(getFunction()));
    return b.toString();
  }

  public void setFunction (final int function)
  {
    this.function = function;
  }

  public int getFunction ()
  {
    return function;
  }

  /**
   * A callback function to inform the object, that the x scale has changed and the
   * internal coordinate values have to be adjusted.
   */
  protected void scaleXChanged ()
  {
  }

  /**
   * A callback function to inform the object, that the y scale has changed and the
   * internal coordinate values have to be adjusted.
   */
  protected void scaleYChanged ()
  {
  }
}
