/**
 * ========================================
 * Pixie : a free Java vector image library
 * ========================================
 *
 * Project Info:  http://www.jfree.org/jfreereport/pixie/
 * Project Lead:  Thomas Morgner;
 *
 * (C) Copyright 2000-2005, by Object Refinery Limited and Contributors.
 * (C) Copyright 2006, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * DIBReader.java
 * ------------
 * (C) Copyright 2006, by Pentaho Corporation.
 *
 * Original Author:  Thomas Morgner;
 * Contributor(s):   -;
 *
 * $Id: DIBReader.java,v 1.5 2006/04/17 15:03:24 taqua Exp $
 *
 * Changes
 * -------
 *
 *
 */

package com.benryan.graphics.wmf.bitmap;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.imageio.ImageIO;

//import org.jfree.pixie.wmf.BitmapCompression;
//import org.jfree.pixie.wmf.BitmapCompressionFactory;
//import org.jfree.pixie.wmf.BitmapHeader;
//import org.jfree.pixie.wmf.GDIPalette;

import com.benryan.graphics.wmf.MfRecord;

public class DIBReader
{
  private GDIPalette palette; // as GDI Color value
  private BitmapHeader header;

  public DIBReader ()
  {
  }

  public BufferedImage setRecord (final MfRecord record)
          throws IOException
  {
    return setRecord(record, 0, false, false);
  }

  public BufferedImage setRecord (final MfRecord record, int offset, boolean reverseHeight, boolean reverseWidth)
          throws IOException
  {
    offset += 6;
  
    if (reverseWidth)
    {
      int negWidth = -1 * record.getInt(offset + 4);
      record.setInt(offset + 4, negWidth);
    }
    
    if (reverseHeight)
    {
      int negHeight = -1 * record.getInt(offset + 8);
      record.setInt(offset + 8, negHeight);
    }
    
    byte[] fileHeader = new byte[]{0x42, 0x4d,0,0,0,0,0,0,0,0,0x36,0,0,0}; 
    byte[] dibData = record.getRawData();
    int fileSize = dibData.length - offset + fileHeader.length;
    
    fileHeader[2] = (byte)(fileSize & 0xff);
    fileHeader[3] = (byte)((fileSize & 0xff00) >> 8);
    fileHeader[4] = (byte)((fileSize & 0xff0000) >> 16);
    fileHeader[5] = (byte)((fileSize & 0xff000000) >> 32);
    
    
    byte[] imgBuf = new byte[fileSize];
    System.arraycopy(fileHeader, 0, imgBuf, 0, fileHeader.length);
    System.arraycopy(dibData, offset, imgBuf, fileHeader.length, dibData.length - offset);   
      
//    FileOutputStream out = new FileOutputStream("c:\\testbmp.bmp");
//    out.write(imgBuf);
//    out.flush();
//    out.close();
    
    return ImageIO.read(new ByteArrayInputStream(imgBuf));
//    header = new BitmapHeader();
//    header.setRecord(record, offset);
//    palette = new GDIPalette();
//    palette.setNoOfColors(header.getNoOfColors());
//
//    final int width = header.getWidth();
//    final int height = header.getHeight();
//
//    final int paletteStart = MfRecord.RECORD_HEADER_SIZE + header.getHeaderSize() + 4 + offset;
//    final InputStream dataIn = record.getInputStream(paletteStart);
//    palette.readPalette(dataIn);
//
//    final int compression = header.getCompression();
//    final BitmapCompression comHandler = BitmapCompressionFactory.getHandler(compression);
//    comHandler.setDimension(width, height);
//    comHandler.setBpp(header.getBitsPerPixel());
//    final int[] data = comHandler.decompress(dataIn, palette);
//
//    final BufferedImage retval = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
//    retval.setRGB(0, 0, width, height, data, 0, width);
//    return retval;
  }
}
