/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.jdbc.interceptors.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.ofbiz.core.entity.config.ConnectionPoolInfo;
import org.ofbiz.core.entity.jdbc.SQLInterceptorSupport;
import org.ofbiz.core.entity.jdbc.interceptors.SQLInterceptor;
import org.ofbiz.core.entity.jdbc.interceptors.connection.ConnectionPoolState;
import org.ofbiz.core.entity.jdbc.interceptors.connection.ConnectionWithSQLInterceptor;
import org.ofbiz.core.entity.jdbc.interceptors.connection.DelegatingConnection;
import org.ofbiz.core.entity.jdbc.interceptors.connection.SQLConnectionInterceptor;

public class ConnectionTracker {
    static final ConnectionPoolInfo UNKNOWN_CONNECTION_POOL_INFO = new ConnectionPoolInfo(-1, -1, -1L, -1L, -1L, -1L, -1L, null, -1L, -1L);
    private final ConnectionPoolInfo connectionPoolInfo;
    private final AtomicInteger borrowedCount = new AtomicInteger(0);

    public ConnectionTracker() {
        this(UNKNOWN_CONNECTION_POOL_INFO);
    }

    public ConnectionTracker(ConnectionPoolInfo connectionPoolInfo) {
        this.connectionPoolInfo = connectionPoolInfo != null ? connectionPoolInfo : UNKNOWN_CONNECTION_POOL_INFO;
    }

    public Connection trackConnection(String helperName, Callable<Connection> getConnectionCall) {
        try {
            long then = System.nanoTime();
            Connection connection = getConnectionCall.call();
            return this.informInterceptor(helperName, connection, this.connectionPoolInfo, System.nanoTime() - then);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to obtain a connection from the underlying connection pool", e);
        }
    }

    private Connection informInterceptor(String helperName, Connection connection, ConnectionPoolInfo connectionPoolInfo, long timeTakenNanos) {
        if (connection == null) {
            return null;
        }
        int count = this.borrowedCount.incrementAndGet();
        SQLConnectionInterceptor sqlConnectionInterceptor = SQLInterceptorSupport.getNonNullSQLConnectionInterceptor(helperName);
        sqlConnectionInterceptor.onConnectionTaken(connection, new ConnectionPoolStateImpl(timeTakenNanos, count, connectionPoolInfo));
        return new DelegatingConnectionImpl(connection, connectionPoolInfo, sqlConnectionInterceptor);
    }

    private static class ConnectionPoolStateImpl
    implements ConnectionPoolState {
        private final long timeToBorrowNanos;
        private final int borrowCount;
        private final ConnectionPoolInfo connectionPoolInfo;

        private ConnectionPoolStateImpl(long timeToBorrowNanos, int borrowCount, ConnectionPoolInfo connectionPoolInfo) {
            this.timeToBorrowNanos = timeToBorrowNanos;
            this.borrowCount = borrowCount;
            this.connectionPoolInfo = connectionPoolInfo;
        }

        @Override
        public long getTimeToBorrowNanos() {
            return this.timeToBorrowNanos;
        }

        @Override
        public long getTimeToBorrow() {
            return this.timeToBorrowNanos / 1000000L;
        }

        @Override
        public int getBorrowedCount() {
            return this.borrowCount;
        }

        @Override
        public ConnectionPoolInfo getConnectionPoolInfo() {
            return this.connectionPoolInfo;
        }

        public String toString() {
            return "ConnectionPoolStateImpl[timeToBorrowNanos=" + this.timeToBorrowNanos + ",borrowCount=" + this.borrowCount + ",connectionPoolInfo=" + this.connectionPoolInfo + "]";
        }
    }

    private class DelegatingConnectionImpl
    extends DelegatingConnection
    implements ConnectionWithSQLInterceptor {
        private final ConnectionPoolInfo connectionPoolInfo;
        private final SQLConnectionInterceptor sqlConnectionInterceptor;

        public DelegatingConnectionImpl(Connection delegate, ConnectionPoolInfo connectionPoolInfo, SQLConnectionInterceptor sqlConnectionInterceptor) {
            super(delegate);
            this.connectionPoolInfo = connectionPoolInfo;
            this.sqlConnectionInterceptor = sqlConnectionInterceptor;
        }

        @Override
        public void close() throws SQLException {
            super.close();
            int count = ConnectionTracker.this.borrowedCount.decrementAndGet();
            this.sqlConnectionInterceptor.onConnectionReplaced(this, new ConnectionPoolStateImpl(0L, count, this.connectionPoolInfo));
        }

        @Override
        public SQLInterceptor getNonNullSQLInterceptor() {
            return this.sqlConnectionInterceptor;
        }

        public String toString() {
            return "DelegatingConnectionImpl[connectionPoolInfo=" + this.connectionPoolInfo + ",sqlConnectionInterceptor=" + this.sqlConnectionInterceptor + "]";
        }
    }
}

