/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.jdbc.dbtype;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.ofbiz.core.entity.jdbc.dbtype.AbstractDatabaseType;

public abstract class AbstractPostgresDatabaseType
extends AbstractDatabaseType {
    private static final int MAJOR = 0;
    private static final int MINOR = 1;

    protected AbstractPostgresDatabaseType(String name, String fieldTypeName) {
        super(name, fieldTypeName, new String[]{"POSTGRESQL"});
    }

    @Override
    public String getSchemaName(Connection con) {
        return "public";
    }

    protected int[] parseVersionStr(String version) {
        int[] versionNumber = new int[]{0, 0};
        StringTokenizer versionTokens = new StringTokenizer(version, ".");
        if (versionTokens.hasMoreElements()) {
            versionNumber[0] = Integer.parseInt(versionTokens.nextToken());
            if (versionTokens.hasMoreElements()) {
                versionNumber[1] = Integer.parseInt(versionTokens.nextToken());
            }
        }
        return versionNumber;
    }

    protected int[] getPostgresVersion(Connection con) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        try {
            int[] versionNumber = new int[]{0, 0};
            versionNumber[0] = metaData.getDatabaseMajorVersion();
            versionNumber[1] = metaData.getDatabaseMinorVersion();
            return versionNumber;
        }
        catch (AbstractMethodError ame) {
            return this.parseVersionStr(metaData.getDatabaseProductVersion());
        }
    }

    protected boolean postgresVersionGreaterThanOrEqual(Connection con, int major, int minor) throws SQLException {
        int[] vers = this.getPostgresVersion(con);
        return AbstractPostgresDatabaseType.versionGreaterThanOrEqual(vers[0], vers[1], major, minor);
    }

    protected boolean postgresVersionLessThanOrEqual(Connection con, int major, int minor) throws SQLException {
        int[] vers = this.getPostgresVersion(con);
        return AbstractPostgresDatabaseType.versionGreaterThanOrEqual(major, minor, vers[0], vers[1]);
    }

    @Override
    public String getSimpleSelectSqlSyntax(boolean clusterMode) {
        if (clusterMode) {
            return "SELECT {0} FROM {1} WHERE {2} FOR UPDATE";
        }
        return "SELECT {0} FROM {1} WHERE {2}";
    }
}

